/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.gamestages;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.Validate;

public class GamestagesMatcher
implements IPlayerMatcher {
    private final Set<String> stages;
    private final boolean matchAll;

    public GamestagesMatcher(Collection<String> stages, boolean matchAll) {
        stages.forEach(s -> Validate.isTrue((boolean)GameStageHelper.isStageKnown((String)s), (String)("unknown gamestage '" + s + "'!"), (Object[])new Object[0]));
        this.stages = ImmutableSet.copyOf(stages);
        this.matchAll = matchAll;
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.matchAll);
        buffer.m_130130_(this.stages.size());
        this.stages.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.stages.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add(this.matchAll ? "all" : "any", (JsonElement)array);
        return json;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.stages.isEmpty()) {
            MutableComponent header = PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.gamestages", new Object[0]).m_130946_(" (").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.matchAll ? "all" : "any"), new Object[0])).m_130946_(")");
            List<Component> items = this.stages.stream().map(TextComponent::new).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)header, items);
        }
    }

    @Override
    public boolean test(Player playerEntity) {
        return this.matchAll ? GameStageHelper.hasAllOf((Player)playerEntity, this.stages) : GameStageHelper.hasAnyOf((Player)playerEntity, this.stages);
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<GamestagesMatcher> {
        @Override
        public GamestagesMatcher fromJson(JsonElement json) {
            if (!json.isJsonObject()) {
                throw new JsonSyntaxException("expected JSON object here!");
            }
            JsonObject o = json.getAsJsonObject();
            if (o.has("any")) {
                return new GamestagesMatcher(this.getStrings(o, "any"), false);
            }
            if (o.has("all")) {
                return new GamestagesMatcher(this.getStrings(o, "all"), true);
            }
            throw new JsonSyntaxException("element must contain one of 'all' or 'any'");
        }

        private Collection<String> getStrings(JsonObject o, String fieldName) {
            return Streams.stream((Iterator)GsonHelper.m_13933_((JsonObject)o, (String)fieldName).iterator()).map(JsonElement::getAsString).collect(Collectors.toList());
        }

        @Override
        public GamestagesMatcher fromBytes(FriendlyByteBuf buffer) {
            boolean matchAll = buffer.readBoolean();
            int n = buffer.m_130242_();
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                l.add(buffer.m_130136_(64));
            }
            return new GamestagesMatcher(l, matchAll);
        }
    }
}

