/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.misc.RangedInt;
import me.desht.pneumaticcraft.api.universal_sensor.IBlockAndCoordinatePollSensor;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.math.NumberUtils;

public class BlockHeatSensor
implements IBlockAndCoordinatePollSensor {
    @Override
    public String getSensorPath() {
        return "Block/Heat";
    }

    @Override
    public Set<PNCUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)((Object)((PNCUpgrade)((Object)ModUpgrades.BLOCK_TRACKER.get()))));
    }

    @Override
    public int getPollFrequency() {
        return 20;
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public RangedInt getTextboxIntRange() {
        return new RangedInt(-273, 2000);
    }

    @Override
    public int getRedstoneValue(Level world, BlockPos pos, int sensorRange, String textBoxText, Set<BlockPos> positions) {
        double temperature = 0.0;
        for (BlockPos p : positions) {
            temperature = Math.max(temperature, HeatExchangerManager.getInstance().getLogic(world, p, null).map(IHeatExchangerLogic::getTemperature).orElse(0.0));
            BlockEntity te = world.m_7702_(p);
            if (te == null) continue;
            for (Direction side : DirectionUtil.VALUES) {
                temperature = Math.max(temperature, te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).map(IHeatExchangerLogic::getTemperature).orElse(0.0));
            }
        }
        return NumberUtils.isCreatable((String)textBoxText) ? (temperature - 273.0 > (double)NumberUtils.toInt((String)textBoxText) ? 15 : 0) : HeatUtil.getComparatorOutput((int)temperature);
    }

    @Override
    public void getAdditionalInfo(List<Component> info) {
        info.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.universalSensor.text.thresholdTemp", new Object[0]));
    }
}

