/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateGui {
    private final int syncId;
    private final Object value;
    private final byte type;

    public PacketUpdateGui(int syncId, SyncedField<?> syncField) {
        this.syncId = syncId;
        this.value = syncField.getValue();
        this.type = SyncedField.getType(syncField);
    }

    public PacketUpdateGui(FriendlyByteBuf buf) {
        this.syncId = buf.m_130242_();
        this.type = buf.readByte();
        this.value = SyncedField.fromBytes(buf, this.type);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.syncId);
        buf.writeByte((int)this.type);
        SyncedField.toBytes(buf, this.value, this.type);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientUtils.syncViaOpenContainerScreen(this.syncId, this.value));
        ctx.get().setPacketHandled(true);
    }
}

