/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.SecurityStationHackingScreen;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class NetworkComponentItem
extends Item
implements IProgrammable {
    private final NetworkComponentType type;

    public NetworkComponentItem(NetworkComponentType type) {
        super(ModItems.defaultProps());
        this.type = type;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> curInfo, TooltipFlag extraInfo) {
        super.m_7373_(stack, worldIn, curInfo, extraInfo);
        if (worldIn != null && worldIn.f_46443_) {
            SecurityStationHackingScreen.addExtraHackInfoStatic(curInfo);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.m_20193_().f_46443_ && this.canProgram(stack) && stack.m_41782_() && stack.m_41783_().m_128441_("pneumaticcraft:progWidgets")) {
            entity.m_32064_();
        }
        return false;
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.type == NetworkComponentType.NETWORK_API || this.type == NetworkComponentType.NETWORK_DATA_STORAGE;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return this.type == NetworkComponentType.NETWORK_API;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    public static NetworkComponentType getType(ItemStack stack) {
        return stack.m_41720_() instanceof NetworkComponentItem ? ((NetworkComponentItem)stack.m_41720_()).type : null;
    }

    public static enum NetworkComponentType {
        DIAGNOSTIC_SUBROUTINE("diagnostic_subroutine", true),
        NETWORK_API("network_api", false),
        NETWORK_DATA_STORAGE("network_data_storage", false),
        NETWORK_IO_PORT("network_io_port", true),
        NETWORK_REGISTRY("network_registry", true),
        NETWORK_NODE("network_node", true);

        private final String name;
        private final boolean secStationComponent;

        private NetworkComponentType(String name, boolean secStationComponent) {
            this.name = name;
            this.secStationComponent = secStationComponent;
        }

        public boolean isSecStationComponent() {
            return this.secStationComponent;
        }

        public String getRegistryName() {
            return this.name;
        }
    }
}

