/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ManometerItem
extends PressurizableItem {
    public ManometerItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
            BlockEntity te;
            if (h.getAir() < 30) {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", stack.m_41786_()).m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            ArrayList<Component> curInfo = new ArrayList<Component>();
            Direction side = context.m_43719_();
            BlockPos pos = context.m_8083_();
            BlockState state = world.m_8055_(pos.m_142300_(side));
            if (!player.m_6144_() && state.m_60734_() instanceof LiquidBlock) {
                pos = pos.m_142300_(side);
            }
            if ((te = world.m_7702_(pos)) != null) {
                TemperatureData tempData;
                if (te instanceof Nameable) {
                    curInfo.add((Component)((Nameable)te).m_5446_().m_6881_().m_130940_(ChatFormatting.AQUA));
                } else {
                    curInfo.add((Component)PneumaticCraftUtils.xlate(te.m_58900_().m_60734_().m_7705_(), new Object[0]).m_130940_(ChatFormatting.AQUA));
                }
                if (te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) {
                    te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(teAirHandler -> teAirHandler.printManometerMessage(player, curInfo));
                } else {
                    te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, side).ifPresent(teAirHandler -> teAirHandler.printManometerMessage(player, curInfo));
                }
                if (te instanceof IManoMeasurable) {
                    ((IManoMeasurable)te).printManometerMessage(player, curInfo);
                }
                if ((tempData = new TemperatureData((ICapabilityProvider)te)).isMultisided()) {
                    for (Direction face : DirectionUtil.VALUES) {
                        if (!tempData.hasData(face)) continue;
                        curInfo.add(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
                    }
                } else if (tempData.hasData(null)) {
                    curInfo.add(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
                } else {
                    HeatExchangerManager.getInstance().getLogic(world, pos, side).ifPresent(logic -> curInfo.add(HeatUtil.formatHeatString((int)logic.getTemperature())));
                }
            } else {
                BlockState state1 = world.m_8055_(pos);
                if (state1.m_60734_() instanceof LiquidBlock) {
                    FlowingFluid f = ((LiquidBlock)state1.m_60734_()).getFluid();
                    FluidStack fs = new FluidStack((Fluid)f, 1000);
                    curInfo.add((Component)fs.getDisplayName().m_6881_().m_130940_(ChatFormatting.AQUA));
                } else {
                    curInfo.add((Component)PneumaticCraftUtils.xlate(world.m_8055_(pos).m_60734_().m_7705_(), new Object[0]).m_130940_(ChatFormatting.AQUA));
                }
                HeatExchangerManager.INSTANCE.getLogic(world, pos, side).ifPresent(logic -> curInfo.add(HeatUtil.formatHeatString(logic.getTemperatureAsInt())));
            }
            this.checkForHeatExtraction(world, pos, curInfo);
            if (curInfo.size() > 0) {
                for (int i = 1; i < curInfo.size(); ++i) {
                    curInfo.set(i, (Component)Symbols.bullet().m_7220_((Component)curInfo.get(i)));
                }
                h.addAir(-30);
                curInfo.forEach(s -> player.m_5661_(s, false));
            }
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    private void checkForHeatExtraction(Level world, BlockPos pos, List<Component> curInfo) {
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te1 = world.m_7702_(pos.m_142300_(d));
            if (te1 == null) continue;
            te1.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, d.m_122424_()).ifPresent(handler -> handler.getHeatBehaviour(pos, HeatBehaviourTransition.class).ifPresent(behaviour -> {
                double progress = behaviour.getExtractionProgress();
                if (progress != 0.0) {
                    String key = "pneumaticcraft.waila.temperature" + (progress < 0.0 ? "Gain" : "Loss");
                    int pct = progress < 0.0 ? (int)(progress * -100.0) : (int)(progress * 100.0);
                    curInfo.add((Component)new TranslatableComponent(key, new Object[]{pct}));
                }
            }));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
            if (h.getPressure() >= 0.1f) {
                double temp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)worldIn, playerIn.m_142538_());
                playerIn.m_5661_((Component)ItemStack.f_41583_.m_41786_().m_6881_().m_130940_(ChatFormatting.AQUA), false);
                playerIn.m_5661_((Component)Symbols.bullet().m_7220_(HeatUtil.formatHeatString((int)temp)), false);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }).orElse(InteractionResultHolder.m_19098_((Object)stack));
    }

    public InteractionResult m_6880_(ItemStack iStack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!player.f_19853_.f_46443_) {
            return iStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                if (h.getAir() < 30) {
                    player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", iStack.m_41786_()).m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                ArrayList<Component> curInfo = new ArrayList<Component>();
                if (entity instanceof IManoMeasurable) {
                    ((IManoMeasurable)entity).printManometerMessage(player, curInfo);
                } else {
                    curInfo.add((Component)entity.m_5446_().m_6881_().m_130940_(ChatFormatting.AQUA));
                }
                if (curInfo.size() > 0) {
                    h.addAir(-30);
                    for (int i = 1; i < curInfo.size(); ++i) {
                        curInfo.set(i, (Component)Symbols.bullet().m_7220_((Component)curInfo.get(i)));
                    }
                    curInfo.forEach(s -> player.m_5661_(s, false));
                }
                return InteractionResult.SUCCESS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.SUCCESS;
    }
}

