/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.ClassifyFilterScreen;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class ClassifyFilterItem
extends Item
implements IFilteringItem {
    private static final String NBT_FILTER = "Filter";
    private static final String NBT_CONDITIONS = "Conditions";
    private static final String NBT_MATCH_ALL = "MatchAll";

    public ClassifyFilterItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            ClassifyFilterScreen.openGui(stack.m_41786_(), pUsedHand);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public boolean matchFilter(ItemStack filterStack, ItemStack stack) {
        Validate.isTrue((boolean)(filterStack.m_41720_() instanceof ClassifyFilterItem), (String)"filter item stack is not a Classify Filter!", (Object[])new Object[0]);
        return FilterSettings.fromStack(filterStack).test(stack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        FilterSettings settings = FilterSettings.fromStack(pStack);
        pTooltipComponents.add((Component)ClassifyFilterItem.xlateMatch(settings.matchAll()).m_130940_(ChatFormatting.YELLOW));
        for (FilterCondition c : settings.filterConditions()) {
            pTooltipComponents.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate(c.getTranslationKey(), new Object[0])).m_130940_(ChatFormatting.GOLD));
        }
    }

    private static boolean isCookable(RecipeType<? extends AbstractCookingRecipe> type, ItemStack stack) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129783_();
        if (level == null) {
            return false;
        }
        SimpleContainer c = new SimpleContainer(1);
        c.m_6836_(0, stack);
        return level.m_7465_().m_44015_(type, (Container)c, (Level)level).isPresent();
    }

    public static TranslatableComponent xlateMatch(boolean matchAll) {
        return PneumaticCraftUtils.xlate(matchAll ? "pneumaticcraft.gui.tooltip.filter.matchAll" : "pneumaticcraft.gui.tooltip.filter.matchAny", new Object[0]);
    }

    public record FilterSettings(boolean matchAll, Collection<FilterCondition> filterConditions) implements Predicate<ItemStack>
    {
        private static final FilterSettings NONE = new FilterSettings(false, Collections.emptyList());

        public static FilterSettings fromStack(ItemStack filterStack) {
            CompoundTag tag = filterStack.m_41737_(ClassifyFilterItem.NBT_FILTER);
            if (tag == null) {
                return NONE;
            }
            ListTag l = tag.m_128437_(ClassifyFilterItem.NBT_CONDITIONS, 8);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < l.size(); ++i) {
                try {
                    builder.add((Object)FilterCondition.valueOf(l.m_128778_(i)));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return new FilterSettings(tag.m_128471_(ClassifyFilterItem.NBT_MATCH_ALL), (Collection<FilterCondition>)builder.build());
        }

        public void save(ItemStack stack) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128379_(ClassifyFilterItem.NBT_MATCH_ALL, this.matchAll);
            ListTag l = new ListTag();
            this.filterConditions.forEach(c -> l.add((Object)StringTag.m_129297_((String)c.toString())));
            subTag.m_128365_(ClassifyFilterItem.NBT_CONDITIONS, (Tag)l);
            stack.m_41784_().m_128365_(ClassifyFilterItem.NBT_FILTER, (Tag)subTag);
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.matchAll ? this.filterConditions.stream().allMatch(c -> c.test(stack)) : this.filterConditions.stream().anyMatch(c -> c.test(stack));
        }
    }

    public static enum FilterCondition implements ITranslatableEnum,
    Predicate<ItemStack>
    {
        FUEL_ITEM((ItemLike)Items.f_42413_, s -> ForgeHooks.getBurnTime((ItemStack)s, (RecipeType)RecipeType.f_44108_) > 0),
        EDIBLE((ItemLike)Items.f_42406_, s -> s.m_41614_()),
        PLACEABLE((ItemLike)Items.f_41905_, s -> s.m_41720_() instanceof BlockItem),
        FLUID_CONTAINER((ItemLike)Items.f_42446_, s -> s.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()),
        UNSTACKABLE((ItemLike)Items.f_42614_, s -> s.m_41741_() == 1),
        WEARABLE((ItemLike)Items.f_42407_, s -> s.m_41720_() instanceof ArmorItem),
        TOOL((ItemLike)Items.f_42385_, s -> s.m_41720_() instanceof TieredItem),
        WEAPON((ItemLike)Items.f_42383_, s -> s.m_41720_() instanceof SwordItem || s.m_41720_() instanceof AxeItem || s.m_41720_() instanceof ProjectileWeaponItem),
        ENCHANTABLE((ItemLike)Items.f_42517_, s -> s.m_41792_() && !s.m_41793_()),
        ENCHANTED((ItemLike)Items.f_42690_, s -> s.m_41793_()),
        SMELTABLE((ItemLike)Blocks.f_50094_, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44108_, s)),
        BLASTABLE((ItemLike)Blocks.f_50620_, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44109_, s)),
        SMOKABLE((ItemLike)Blocks.f_50619_, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44110_, s)),
        CAMPFIRE_COOKABLE((ItemLike)Blocks.f_50683_, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44111_, s));

        private final ItemStack icon;
        private final Predicate<ItemStack> predicate;

        private FilterCondition(ItemLike icon, Predicate<ItemStack> predicate) {
            this.icon = new ItemStack(icon);
            this.predicate = predicate;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.predicate.test(stack);
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tooltip.filter." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

