/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PneumaticArmorHandler {
    private static final Map<Integer, Integer> targetingTracker = new HashMap<Integer, Integer>();
    private static final Map<UUID, Map<String, Integer>> targetWarnings = new HashMap<UUID, Map<String, Integer>>();
    private static final int ARMOR_REPAIR_AMOUNT = 16;

    @SubscribeEvent
    public void onMobTargetSet(LivingSetAttackTargetEvent event) {
        int mobId = event.getEntityLiving().m_142049_();
        LivingEntity livingEntity = event.getTarget();
        if (livingEntity instanceof ServerPlayer) {
            CommonArmorHandler handler;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (PneumaticArmorItem.isPneumaticArmorPiece((Player)player, EquipmentSlot.HEAD) && (!targetingTracker.containsKey(mobId) || targetingTracker.get(mobId).intValue() != event.getTarget().m_142049_()) && (handler = CommonArmorHandler.getHandlerForPlayer((Player)player)).upgradeUsable(CommonUpgradeHandlers.entityTrackerHandler, true)) {
                Map map = targetWarnings.computeIfAbsent(player.m_142081_(), k -> new HashMap());
                map.merge(event.getEntityLiving().m_7755_().getString(), 1, Integer::sum);
            }
            targetingTracker.put(mobId, event.getTarget().m_142049_());
        } else {
            targetingTracker.remove(mobId);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        targetingTracker.remove(event.getEntityLiving().m_142049_());
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        Entity entity;
        if (event.getDistance() > 3.0f && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            float origDistance = event.getDistance();
            ItemStack stack = player.m_6844_(EquipmentSlot.FEET);
            if (!(stack.m_41720_() instanceof PneumaticArmorItem)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
            if (event.getEntity().f_19853_.m_46791_() == Difficulty.HARD && jbState.isActive()) {
                event.setDamageMultiplier(0.2f);
                return;
            }
            if (handler.upgradeUsable(CommonUpgradeHandlers.jumpBoostHandler, true)) {
                event.setDistance(Math.max(0.0f, event.getDistance() - 1.5f * (float)handler.getUpgradeCount(EquipmentSlot.LEGS, (PNCUpgrade)((Object)ModUpgrades.JUMPING.get()))));
                if (event.getDistance() < 2.0f) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (!player.f_19853_.f_46443_) {
                float airNeeded = event.getDistance() * 20.0f;
                float extraAirNeeded = 0.0f;
                int vol = stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getVolume).orElse(0);
                float airAvailable = (float)vol * handler.getArmorPressure(EquipmentSlot.FEET);
                ArrayList<Entity> stomped = new ArrayList<Entity>();
                if (handler.upgradeUsable(CommonUpgradeHandlers.stompHandler, true)) {
                    for (Entity e2 : player.f_19853_.m_6249_((Entity)player, new AABB(player.m_142538_()).m_82400_(7.0), e -> e instanceof Mob && e.m_6084_())) {
                        if (!(airAvailable > airNeeded + extraAirNeeded)) break;
                        stomped.add(e2);
                        extraAirNeeded += airNeeded;
                    }
                }
                if (airAvailable < 1.0f) {
                    return;
                }
                if (airAvailable >= airNeeded + extraAirNeeded) {
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(1.0f - airAvailable / airNeeded);
                }
                int i = 0;
                while ((float)i < event.getDistance() / 2.0f) {
                    float sx = player.m_21187_().nextFloat() * 0.6f - 0.3f;
                    float sz = player.m_21187_().nextFloat() * 0.6f - 0.3f;
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.m_20185_(), player.m_20186_(), player.m_20189_(), sx, 0.1, sz), player.f_19853_, player.m_142538_());
                    ++i;
                }
                for (Entity e2 : stomped) {
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123813_, e2.m_20185_(), e2.m_20186_(), e2.m_20189_(), 0.0, 0.0, 0.0), player.f_19853_, player.m_142538_());
                    e2.m_6469_(DamageSource.m_19373_((LivingEntity)player), Mth.m_14036_((float)(origDistance / 3.0f), (float)1.0f, (float)20.0f));
                }
                if (!stomped.isEmpty()) {
                    player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
                }
                player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)ModSounds.SHORT_HISS.get(), SoundSource.PLAYERS, 0.3f, 0.8f);
                handler.addAir(EquipmentSlot.FEET, (int)(-(airNeeded + extraAirNeeded)));
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        CommonArmorHandler handler;
        Player player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player && PneumaticArmorItem.isPneumaticArmorPiece(player = (Player)livingEntity, EquipmentSlot.CHEST) && event.getSource().m_19384_() && !player.m_7500_() && !player.m_5833_() && (handler = CommonArmorHandler.getHandlerForPlayer(player)).isArmorEnabled() && handler.hasMinPressure(EquipmentSlot.CHEST) && handler.getUpgradeCount(EquipmentSlot.CHEST, (PNCUpgrade)((Object)ModUpgrades.SECURITY.get())) > 0) {
            event.setCanceled(true);
            player.m_20095_();
            if (!player.f_19853_.f_46443_) {
                handler.addAir(EquipmentSlot.CHEST, -50);
                for (int i = 0; i < 2; ++i) {
                    float sx = player.m_21187_().nextFloat() * 1.5f - 0.75f;
                    float sz = player.m_21187_().nextFloat() * 1.5f - 0.75f;
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.m_20185_() + (double)sx, player.m_20186_() + 1.0, player.m_20189_() + (double)sz, sx / 4.0f, -0.2, sz / 4.0f), player.f_19853_, player.m_142538_());
                }
                if ((player.f_19797_ & 0xF) == 0) {
                    player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)ModSounds.LEAKING_GAS.get(), SoundSource.PLAYERS, 1.0f, 0.7f);
                    this.tryExtinguish(player);
                }
            }
        }
    }

    private void tryExtinguish(Player player) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = player.m_142538_().m_142082_(i, 0, j);
                BlockState state = player.f_19853_.m_8055_(pos);
                if (state.m_60734_() == Blocks.f_50083_ && player.m_21187_().nextInt(3) == 0) {
                    player.f_19853_.m_7471_(pos, false);
                    continue;
                }
                if (state.m_60734_() != Blocks.f_49991_ || player.m_21187_().nextInt(5) != 0) continue;
                int level = (Integer)state.m_61143_((Property)LiquidBlock.f_54688_);
                player.f_19853_.m_46597_(pos, level == 0 ? Blocks.f_50080_.m_49966_() : Blocks.f_50652_.m_49966_());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = player.m_6844_(EquipmentSlot.LEGS);
            if (!(stack.m_41720_() instanceof PneumaticArmorItem)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (handler.upgradeUsable(CommonUpgradeHandlers.jetBootsHandler, true) && !handler.getExtensionData(CommonUpgradeHandlers.jetBootsHandler).isSmartHover()) {
                return;
            }
            if (handler.upgradeUsable(CommonUpgradeHandlers.jumpBoostHandler, true)) {
                float power = (float)PneumaticArmorItem.getIntData(stack, "jumpBoost", 100, 0, 100) / 100.0f;
                int rangeUpgrades = handler.getUpgradeCount(EquipmentSlot.LEGS, (PNCUpgrade)((Object)ModUpgrades.JUMPING.get()), player.m_6144_() ? 1 : 4);
                float actualBoost = Math.max(1.0f, (float)rangeUpgrades * power);
                Vec3 m = player.m_20184_();
                double scale = player.m_20142_() ? (double)actualBoost : (double)actualBoost * 0.6;
                player.m_20334_(m.f_82479_ * scale, m.f_82480_ + (double)(actualBoost * 0.15f), m.f_82481_ * scale);
                int airUsed = (int)Math.ceil(25.0f * actualBoost * (float)(player.m_20142_() ? 2 : 1));
                handler.addAir(EquipmentSlot.LEGS, -airUsed);
            }
        }
    }

    @SubscribeEvent
    public void breakSpeedCheck(PlayerEvent.BreakSpeed event) {
        Player player = event.getPlayer();
        int max = 5;
        if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.FEET) && !player.m_20096_()) {
            int n;
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(event.getPlayer());
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
            if (jbState.isEnabled() && jbState.isBuilderMode() && (n = max + 1 - handler.getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)((Object)ModUpgrades.JET_BOOTS.get()), max)) < 4) {
                float newSpeed;
                float mult = 5.0f / (float)n;
                float oldSpeed = event.getOriginalSpeed();
                if (oldSpeed < (newSpeed = event.getNewSpeed()) * mult) {
                    event.setNewSpeed(newSpeed * mult);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        CommonArmorHandler handler;
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && PneumaticArmorItem.isPneumaticArmorPiece(player = (Player)entity, EquipmentSlot.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(player)).hasMinPressure(EquipmentSlot.FEET) && handler.isArmorReady(EquipmentSlot.FEET)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.player.f_19853_.f_46443_) {
            this.handleJetbootsPose(event.player);
        } else if (event.player instanceof ServerPlayer && event.player.f_19853_.m_46467_() % 20L == 0L && PneumaticArmorItem.isPneumaticArmorPiece(event.player, EquipmentSlot.HEAD)) {
            this.handleTargetWarnings((ServerPlayer)event.player);
        }
    }

    private void handleJetbootsPose(Player thisPlayer) {
        JetBootsStateTracker tracker = JetBootsStateTracker.getClientTracker();
        int distThresholdSq = ClientUtils.getRenderDistanceThresholdSq();
        for (Player otherPlayer : thisPlayer.f_19853_.m_6907_()) {
            JetBootsStateTracker.JetBootsState state;
            if (otherPlayer.m_20096_() || !PneumaticArmorItem.isPneumaticArmorPiece(otherPlayer, EquipmentSlot.FEET) || (state = tracker.getJetBootsState(otherPlayer)) == null || !state.isEnabled() || otherPlayer.m_21255_() && !state.isActive() || !(otherPlayer.m_20280_((Entity)thisPlayer) < (double)distThresholdSq) || otherPlayer.m_142049_() == thisPlayer.m_142049_() || !state.shouldRotatePlayer()) continue;
            otherPlayer.m_20124_(Pose.FALL_FLYING);
        }
    }

    private void handleTargetWarnings(ServerPlayer player) {
        Map<String, Integer> map = targetWarnings.get(player.m_142081_());
        if (map != null) {
            map.forEach((name, count) -> {
                TranslatableComponent msg = PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.targetWarning", name);
                if (count > 1) {
                    msg.m_130946_(" (x" + count + ")");
                }
                NetworkHandler.sendToPlayer(new PacketSendArmorHUDMessage((Component)msg, 60, 1895776256), player);
            });
            map.clear();
        }
    }

    @SubscribeEvent
    public void onArmorRepair(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof PneumaticArmorItem && new ItemStack((ItemLike)event.getLeft().m_41720_()).m_204117_(PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON)) {
            ItemStack repairedItem = event.getLeft().m_41777_();
            int damageRepaired = Math.min(repairedItem.m_41773_(), event.getRight().m_41613_() * 16);
            int ingotsToUse = (damageRepaired - 1) / 16 + 1;
            repairedItem.m_41721_(repairedItem.m_41773_() - damageRepaired);
            event.setOutput(repairedItem);
            event.setCost(Math.max(1, ingotsToUse / 2));
            event.setMaterialCost(ingotsToUse);
        }
    }

    @SubscribeEvent
    public void onPlayerTrack(PlayerEvent.StartTracking event) {
        CommonArmorHandler handler;
        ServerPlayer trackedPlayer;
        Entity entity;
        if (event.getPlayer() instanceof ServerPlayer && (entity = event.getTarget()) instanceof ServerPlayer && (trackedPlayer = (ServerPlayer)entity).m_6844_(EquipmentSlot.FEET).m_41720_() == ModItems.PNEUMATIC_BOOTS.get() && (handler = CommonArmorHandler.getHandlerForPlayer((Player)trackedPlayer)).getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)((Object)ModUpgrades.JET_BOOTS.get())) > 0) {
            JetBootsStateTracker.JetBootsState state = JetBootsStateTracker.getServerTracker().getJetBootsState((Player)trackedPlayer);
            NetworkHandler.sendToPlayer(new PacketJetBootsStateSync((Player)trackedPlayer, state), (ServerPlayer)event.getPlayer());
        }
    }
}

