/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DroneSpecialVariableHandler {
    private static final Map<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>> DISPATCH_MAP = new HashMap<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>>();
    private static final BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> MISSING = (event, extraParam) -> BlockPos.f_121853_;

    private static void register(String var, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> func) {
        if (DISPATCH_MAP.containsKey(var)) {
            Log.warning("special variable '%s' is already registered! ignoring", new Object[0]);
        } else {
            DISPATCH_MAP.put(var, func);
        }
    }

    @SubscribeEvent
    public void onSpecialVariableRetrieving(SpecialVariableRetrievalEvent.CoordinateVariable.Drone event) {
        String[] s = event.specialVarName.split("=", 2);
        String extra = s.length > 1 ? s[1] : "";
        event.setCoordinate(DISPATCH_MAP.getOrDefault(s[0], MISSING).apply(event, extra));
    }

    private static BlockPos getPosForPlayer(Player player) {
        return player == null ? BlockPos.f_121853_ : player.m_142538_().m_142300_(Direction.UP);
    }

    private static BlockPos getPlayerLookVec(Player player) {
        if (player == null) {
            return BlockPos.f_121853_;
        }
        Direction d = player.m_6350_();
        float pitch = player.m_5686_(0.0f);
        int yDir = Math.abs(pitch) < 45.0f ? 0 : (int)Math.signum(-pitch);
        return new BlockPos(d.m_122429_(), yDir, d.m_122431_());
    }

    static {
        DroneSpecialVariableHandler.register("drone_pos", (event, extra) -> new BlockPos(event.drone.getDronePos()));
        DroneSpecialVariableHandler.register("controller_pos", (event, extra) -> event.drone.getControllerPos());
        DroneSpecialVariableHandler.register("owner_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("player_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer((Player)PneumaticCraftUtils.getPlayerFromName(extra)));
        DroneSpecialVariableHandler.register("deploy_pos", (event, extra) -> event.drone.getDeployPos());
        DroneSpecialVariableHandler.register("owner_look", (event, extra) -> DroneSpecialVariableHandler.getPlayerLookVec(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("owner", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("player", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer((Player)PneumaticCraftUtils.getPlayerFromName(extra)));
        DroneSpecialVariableHandler.register("drone", (event, extra) -> new BlockPos(event.drone.getDronePos()).m_142300_(Direction.UP));
    }
}

