/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.network.NetworkHooks;

public class VortexEntity
extends ThrowableProjectile {
    private int hitCounter = 0;
    private float renderOffsetX = -3.4028235E38f;

    public VortexEntity(EntityType<? extends VortexEntity> type, Level world) {
        super(type, world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            BlockPos.m_121921_((AABB)this.m_142469_()).filter(pos -> this.vortexBreakable(this.f_19853_.m_8055_(pos).m_60734_())).forEach(this::handleVortexCollision);
        }
        this.m_20256_(this.m_20184_().m_82490_(0.95));
        if (this.m_20184_().m_82556_() < 0.1) {
            this.m_146870_();
        }
    }

    public boolean hasRenderOffsetX() {
        return this.renderOffsetX > -3.4028235E38f;
    }

    public float getRenderOffsetX() {
        return this.renderOffsetX;
    }

    public void setRenderOffsetX(float renderOffsetX) {
        this.renderOffsetX = renderOffsetX;
    }

    public float m_7139_() {
        return 0.0f;
    }

    protected void m_6532_(HitResult rtr) {
        if (rtr.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)rtr).m_82443_();
            entity.m_20256_(entity.m_20184_().m_82549_(this.m_20184_().m_82520_(0.0, 0.4, 0.0)));
            ItemStack shears = new ItemStack((ItemLike)Items.f_42574_);
            if (entity instanceof LivingEntity) {
                Player shooter;
                Player player = shooter = this.m_37282_() instanceof Player ? (Player)this.m_37282_() : null;
                if (shooter != null) {
                    shears.m_41720_().m_6880_(shears, shooter, (LivingEntity)entity, InteractionHand.MAIN_HAND);
                }
            }
        } else if (rtr.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)rtr).m_82425_();
            Block block = this.f_19853_.m_8055_(pos).m_60734_();
            if (this.vortexBreakable(block)) {
                if (!this.f_19853_.f_46443_) {
                    this.handleVortexCollision(pos);
                }
            } else {
                this.m_146870_();
            }
        }
        ++this.hitCounter;
        if (this.hitCounter > 20) {
            this.m_146870_();
        }
    }

    private void handleVortexCollision(BlockPos pos) {
        this.f_19853_.m_46961_(pos, true);
        this.m_20256_(this.m_20184_().m_82490_(0.85));
    }

    private boolean vortexBreakable(Block block) {
        return block instanceof IPlantable || block instanceof LeavesBlock || block instanceof WebBlock;
    }

    protected void m_8097_() {
    }
}

