/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class PressureTubeBlockEntity
extends AbstractAirHandlingBlockEntity
implements IAirListener,
IManoMeasurable,
CamouflageableBlockEntity {
    @DescSynced
    private final boolean[] sidesClosed = new boolean[6];
    private final EnumMap<Direction, AbstractTubeModule> modules = new EnumMap(Direction.class);
    private BlockState camoState;
    private AABB renderBoundingBox = null;
    private Direction inLineModuleDir = null;
    private final List<Direction> neighbourDirections = new ArrayList<Direction>();
    private VoxelShape cachedTubeShape = null;
    private int pendingCacheShapeClear = 0;

    public PressureTubeBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.PRESSURE_TUBE.get(), pos, state, PressureTier.TIER_ONE, 1000);
    }

    PressureTubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volumePressureTube) {
        super(type, pos, state, tier, volumePressureTube, 0);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        byte closed = tag.m_128445_("sidesClosed");
        for (int i = 0; i < 6; ++i) {
            this.sidesClosed[i] = (closed & 1 << i) != 0;
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        byte closed = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.sidesClosed[i]) continue;
            closed = (byte)(closed | 1 << i);
        }
        nbt.m_128344_("sidesClosed", closed);
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        this.writeModulesToNBT(tag);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    public void writeModulesToNBT(CompoundTag tag) {
        ListTag moduleList = new ListTag();
        for (Direction d : DirectionUtil.VALUES) {
            AbstractTubeModule tm = this.getModule(d);
            if (tm == null) continue;
            CompoundTag moduleTag = new CompoundTag();
            moduleTag.m_128359_("type", tm.getType().toString());
            tm.writeToNBT(moduleTag);
            moduleList.add((Object)moduleTag);
        }
        tag.m_128365_("modules", (Tag)moduleList);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.clearCachedShape();
        EnumSet<Direction> dirs = EnumSet.allOf(Direction.class);
        ListTag moduleList = tag.m_128437_("modules", 10);
        for (int i = 0; i < moduleList.size(); ++i) {
            CompoundTag moduleTag = moduleList.m_128728_(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(moduleTag.m_128461_("type")));
            Direction dir = Direction.m_122376_((int)moduleTag.m_128451_("dir"));
            if (item instanceof TubeModuleItem) {
                AbstractTubeModule module = ((TubeModuleItem)item).createModule(dir, this);
                module.readFromNBT(moduleTag);
                AbstractTubeModule oldModule = this.getModule(module.getDirection());
                if (oldModule != null && !oldModule.getType().equals((Object)module.getType())) {
                    oldModule.onRemoved();
                }
                this.setModule(module.getDirection(), module);
                dirs.remove(module.getDirection());
                continue;
            }
            Log.error("unknown tube module type: " + moduleTag.m_128461_("type"), new Object[0]);
        }
        for (Direction d : dirs) {
            AbstractTubeModule module = this.getModule(d);
            if (module == null) continue;
            this.setModule(d, null);
        }
        this.updateRenderBoundingBox();
        if (this.m_58898_() && this.nonNullLevel().f_46443_) {
            this.rerenderTileEntity();
        }
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    public void updateRenderBoundingBox() {
        this.renderBoundingBox = new AABB(this.m_58899_());
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.modules.containsKey(dir) || this.modules.get(dir).getRenderBoundingBox() == null) continue;
            this.renderBoundingBox = this.renderBoundingBox.m_82367_(this.modules.get(dir).getRenderBoundingBox());
        }
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (this.pendingCacheShapeClear > 0 && --this.pendingCacheShapeClear == 0) {
            this.cachedTubeShape = null;
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        for (Direction dir : DirectionUtil.VALUES) {
            AbstractTubeModule tm = this.getModule(dir);
            if (tm == null) continue;
            tm.tickClient();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        boolean couldLeak = true;
        for (Direction dir : DirectionUtil.VALUES) {
            AbstractTubeModule tm = this.getModule(dir);
            if (tm != null) {
                couldLeak = false;
                tm.tickServer();
            }
            if (!this.isSideClosed(dir)) continue;
            couldLeak = false;
        }
        if (couldLeak && this.neighbourDirections.size() == 1) {
            Direction d = this.neighbourDirections.get(0).m_122424_();
            this.airHandler.setSideLeaking((Direction)(this.canConnectPneumatic(d) ? d : null));
        } else {
            this.airHandler.setSideLeaking(null);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.nonNullLevel().f_46443_) {
            this.discoverConnectedNeighbors();
        }
    }

    @Override
    public void onAirDispersion(IAirHandlerMachine handler, @Nullable Direction side, int airDispersed) {
        AbstractTubeModule abstractTubeModule;
        if (side != null && (abstractTubeModule = this.getModule(side)) instanceof IInfluenceDispersing) {
            IInfluenceDispersing dispersing = (IInfluenceDispersing)((Object)abstractTubeModule);
            dispersing.onAirDispersion(airDispersed);
        }
    }

    @Override
    public int getMaxDispersion(IAirHandlerMachine handler, @Nullable Direction side) {
        int n;
        AbstractTubeModule abstractTubeModule;
        if (side != null && (abstractTubeModule = this.getModule(side)) instanceof IInfluenceDispersing) {
            IInfluenceDispersing dispersing = (IInfluenceDispersing)((Object)abstractTubeModule);
            n = dispersing.getMaxDispersion();
        } else {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public AbstractTubeModule getModule(Direction side) {
        return this.modules.get(side);
    }

    public boolean isSideClosed(Direction side) {
        return this.sidesClosed[side.m_122411_()];
    }

    public void setSideClosed(Direction side, boolean closed) {
        if (this.sidesClosed[side.m_122411_()] != closed) {
            this.sidesClosed[side.m_122411_()] = closed;
            this.initializeHullAirHandlers();
            this.discoverConnectedNeighbors();
        }
    }

    public Stream<AbstractTubeModule> tubeModules() {
        return this.modules.values().stream().filter(Objects::nonNull);
    }

    public boolean mayPlaceModule(AbstractTubeModule module) {
        Direction side = module.getDirection();
        return this.inLineModuleDir == null && this.getModule(side) == null && !this.isSideClosed(side) && (!module.isInline() || this.getConnectedNeighbor(side) == null);
    }

    public void setModule(Direction side, AbstractTubeModule module) {
        if (module != null) {
            if (module.isInline()) {
                this.inLineModuleDir = side;
            }
        } else {
            if (this.inLineModuleDir == side) {
                this.inLineModuleDir = null;
            }
            if (this.modules.containsKey(side)) {
                this.modules.get(side).onRemoved();
            }
        }
        this.clearCachedShape();
        if (module != null) {
            this.modules.put(side, module);
        } else {
            this.modules.remove(side);
        }
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.m_58904_().m_7731_(this.m_58899_(), PressureTubeBlock.recalculateState((LevelAccessor)this.f_58857_, this.f_58858_, this.m_58900_()), 3);
            this.sendDescriptionPacket();
            this.m_6596_();
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return !(this.inLineModuleDir != null && this.inLineModuleDir.m_122434_() != side.m_122434_() || this.isSideClosed(side) || this.getModule(side) != null && !this.getModule(side).isInline());
    }

    @Override
    public void onNeighborTileUpdate(BlockPos tilePos) {
        super.onNeighborTileUpdate(tilePos);
        this.tubeModules().filter(module -> this.m_58899_().m_142300_(module.getDirection()).equals((Object)tilePos)).forEach(AbstractTubeModule::onNeighborTileUpdate);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.tubeModules().forEach(AbstractTubeModule::onNeighborBlockUpdate);
        this.discoverConnectedNeighbors();
    }

    private void discoverConnectedNeighbors() {
        this.neighbourDirections.clear();
        this.airHandler.getConnectedAirHandlers(this).forEach(connection -> this.neighbourDirections.add(connection.getDirection()));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public BlockEntity getConnectedNeighbor(Direction dir) {
        BlockEntity te;
        AbstractTubeModule tm = this.getModule(dir);
        if (!this.isSideClosed(dir) && (tm == null || tm.isInline() && dir.m_122434_() == tm.getDirection().m_122434_()) && (te = this.getCachedNeighbor(dir)) != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.m_122424_()).isPresent()) {
            return te;
        }
        return null;
    }

    public AABB getRenderBoundingBox() {
        return this.renderBoundingBox != null ? this.renderBoundingBox : new AABB(this.m_58899_());
    }

    @Override
    public void printManometerMessage(Player player, List<Component> text) {
        BlockHitResult blockHitResult;
        AbstractTubeModule tm;
        HitResult hitResult = RayTraceUtils.getEntityLookedObject((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        if (hitResult instanceof BlockHitResult && (tm = this.getModule((blockHitResult = (BlockHitResult)hitResult).m_82434_())) != null) {
            tm.addInfo(text);
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    public VoxelShape getCachedTubeShape(VoxelShape blockShape) {
        if (this.cachedTubeShape == null) {
            this.cachedTubeShape = blockShape;
            this.tubeModules().forEach(module -> {
                this.cachedTubeShape = Shapes.m_83110_((VoxelShape)this.cachedTubeShape, (VoxelShape)module.getShape());
            });
        }
        return this.cachedTubeShape;
    }

    public void clearCachedShape() {
        this.pendingCacheShapeClear = 2;
    }
}

