/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.PneumaticDoorBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.PneumaticDoorBaseMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;

public class PneumaticDoorBaseBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<PneumaticDoorBaseBlockEntity>,
IMinWorkingPressure,
CamouflageableBlockEntity,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<PneumaticDoorBaseBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<PneumaticDoorBaseBlockEntity>("pneumaticDoor.playerNearby", new ItemStack((ItemLike)Items.f_42264_), te -> true), new RedstoneController.ReceivingRedstoneMode<PneumaticDoorBaseBlockEntity>("pneumaticDoor.playerNearbyAndLooking", new ItemStack((ItemLike)Items.f_42545_), te -> true), new RedstoneController.ReceivingRedstoneMode<PneumaticDoorBaseBlockEntity>("pneumaticDoor.woodenDoor", new ItemStack((ItemLike)Items.f_42342_), te -> true), new RedstoneController.ReceivingRedstoneMode<PneumaticDoorBaseBlockEntity>("pneumaticDoor.ironDoor", new ItemStack((ItemLike)Items.f_42341_), te -> true));
    public static final int INVENTORY_SIZE = 1;
    private static final int RS_MODE_NEAR = 0;
    private static final int RS_MODE_NEAR_LOOKING = 1;
    public static final int RS_MODE_WOODEN_DOOR = 2;
    public static final int RS_MODE_IRON_DOOR = 3;
    private PneumaticDoorBlockEntity door;
    private PneumaticDoorBaseBlockEntity doubleDoor;
    @DescSynced
    public boolean rightGoing;
    public float oldProgress;
    @DescSynced
    @LazySynced
    public float progress;
    @DescSynced
    private boolean opening;
    public boolean wasPowered;
    private BlockState camoState;
    @GuiSynced
    public final RedstoneController<PneumaticDoorBaseBlockEntity> rsController = new RedstoneController<PneumaticDoorBaseBlockEntity>(this, REDSTONE_MODES);
    @DescSynced
    private float speedMultiplier;
    @GuiSynced
    private boolean passSignal;
    private int rangeSq;

    public PneumaticDoorBaseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR_BASE.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
    }

    @Override
    public void tickCommonPre() {
        float targetProgress;
        super.tickCommonPre();
        this.oldProgress = this.progress;
        float f = targetProgress = this.opening ? 1.0f : 0.0f;
        if (this.progress < targetProgress) {
            this.progress = (double)this.progress > 0.05 && this.progress < targetProgress - 0.15f ? (this.progress += 0.04f * this.speedMultiplier) : (float)((double)this.progress + Math.min(0.02, (double)(0.01f * this.speedMultiplier)));
            if (this.progress > targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (this.progress > targetProgress) {
            this.progress = (double)this.progress < 0.95 && this.progress > targetProgress + 0.15f ? (this.progress -= 0.04f * this.speedMultiplier) : (float)((double)this.progress - Math.min(0.02, (double)(0.01f * this.speedMultiplier)));
            if (this.progress < targetProgress) {
                this.progress = targetProgress;
            }
        }
        this.door = this.getDoor();
        if (this.door != null) {
            this.door.setRotationAngle(this.progress * 90.0f);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.getPressure() >= 2.0f) {
            if ((this.nonNullLevel().m_46467_() & 0x3FL) == 0L) {
                BlockEntity te = this.nonNullLevel().m_7702_(this.m_58899_().m_5484_(this.getRotation(), 3));
                this.doubleDoor = te instanceof PneumaticDoorBaseBlockEntity ? (PneumaticDoorBaseBlockEntity)te : null;
            }
            this.setOpening(this.shouldOpen() || this.isNeighborOpening());
            this.setNeighborOpening(this.isOpening());
        } else {
            this.setOpening(true);
        }
        this.speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        if (!PneumaticCraftUtils.epsilonEquals(this.oldProgress, this.progress)) {
            this.addAir((int)(-Math.abs(this.oldProgress - this.progress) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades() / this.speedMultiplier)));
        }
        if (this.door != null) {
            this.rightGoing = this.door.rightGoing;
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.rangeSq = IntMath.pow((int)(2 + this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.RANGE.get()))), (int)2);
    }

    private boolean shouldOpen() {
        if (this.door == null) {
            return false;
        }
        return switch (this.rsController.getCurrentMode()) {
            case 0 -> this.hasAnyValidPlayer(player -> true);
            case 1 -> this.hasAnyValidPlayer(this::isPlayerLookingAtDoor);
            case 2, 3 -> {
                if (this.rsController.getCurrentRedstonePower() > 0 || this.opening) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean hasAnyValidPlayer(Predicate<ServerPlayer> pred) {
        if (this.f_58857_ != null && this.f_58857_.m_142572_() != null) {
            Vec3 vec = Vec3.m_82512_((Vec3i)this.m_58899_().m_142300_(this.getRotation()));
            return this.f_58857_.m_142572_().m_6846_().m_11314_().stream().filter(player -> player.m_20238_(vec) <= (double)this.rangeSq).filter(player -> !SecurityStationBlockEntity.isProtectedFromPlayer((Player)player, this.m_58899_(), false)).anyMatch(pred);
        }
        return false;
    }

    private boolean isPlayerLookingAtDoor(ServerPlayer player) {
        Vec3 eyePos = player.m_20299_(0.0f);
        Vec3 endPos = eyePos.m_82549_(player.m_20154_().m_82490_((double)this.rangeSq));
        return this.door.getRenderBoundingBox().m_82371_(eyePos, endPos).isPresent();
    }

    public void setOpening(boolean opening) {
        boolean wasOpening = this.opening;
        this.opening = opening;
        if (this.opening != wasOpening) {
            NetworkHandler.sendToAllTracking((Object)new PacketPlaySound((SoundEvent)ModSounds.PNEUMATIC_DOOR.get(), SoundSource.BLOCKS, this.m_58899_(), 1.0f, 1.0f, false), this);
            this.sendDescriptionPacket();
        }
    }

    public boolean isOpening() {
        return this.opening;
    }

    private boolean isNeighborOpening() {
        return this.doubleDoor != null && this.doubleDoor.shouldOpen();
    }

    public void setNeighborOpening(boolean opening) {
        if (this.doubleDoor != null && this.doubleDoor.getPressure() >= 2.0f) {
            this.doubleDoor.setOpening(opening);
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    private PneumaticDoorBlockEntity getDoor() {
        return this.nonNullLevel().m_141902_(this.m_58899_().m_142300_(this.getRotation()).m_7495_(), (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR.get()).map(teDoor -> {
            if (this.getRotation().m_122427_() == teDoor.getRotation() && !teDoor.rightGoing) {
                return teDoor;
            }
            if (this.getRotation().m_122428_() == teDoor.getRotation() && teDoor.rightGoing) {
                return teDoor;
            }
            return null;
        }).orElse(null);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128457_("extension");
        this.opening = tag.m_128471_("opening");
        this.rightGoing = tag.m_128471_("rightGoing");
        this.passSignal = tag.m_128471_("passSignal");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("extension", this.progress);
        tag.m_128379_("opening", this.opening);
        tag.m_128379_("rightGoing", this.rightGoing);
        tag.m_128379_("passSignal", this.passSignal);
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("pass_signal")) {
            this.passSignal = !this.passSignal;
            this.updateNeighbours();
            this.m_6596_();
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public RedstoneController<PneumaticDoorBaseBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    @Override
    public MutableComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.pneumaticDoor.openWhen", new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new PneumaticDoorBaseMenu(i, playerInventory, this.m_58899_());
    }

    public boolean shouldPassSignalToDoor() {
        return this.passSignal;
    }
}

