/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.ElectrostaticCompressorBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ElectrostaticCompressorMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class ElectrostaticCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<ElectrostaticCompressorBlockEntity>,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<ElectrostaticCompressorBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<ElectrostaticCompressorBlockEntity>("standard.never", new ItemStack((ItemLike)Items.f_42403_), te -> false), new RedstoneController.EmittingRedstoneMode<ElectrostaticCompressorBlockEntity>("electrostaticCompressor.struckByLightning", Textures.JEI_EXPLOSION, te -> te.struckByLightningCooldown > 0));
    public static final int MAX_ELECTROSTATIC_GRID_SIZE = 500;
    private static final int MAX_BARS_ABOVE = 10;
    @GuiSynced
    public final RedstoneController<ElectrostaticCompressorBlockEntity> rsController = new RedstoneController<ElectrostaticCompressorBlockEntity>(this, REDSTONE_MODES);
    private boolean lastRedstoneState;
    public int ironBarsBeneath = 0;
    public int ironBarsAbove = 0;
    private int struckByLightningCooldown;

    public ElectrostaticCompressorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ELECTROSTATIC_COMPRESSOR.get(), pos, state, PressureTier.TIER_TWO, 50000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if ((this.nonNullLevel().m_46467_() & 0x1FL) == 0L) {
            int max = 20;
            this.ironBarsBeneath = 0;
            while (this.ironBarsBeneath < max && ElectrostaticCompressorBlockEntity.isValidGridBlock(this.nonNullLevel().m_8055_(this.m_58899_().m_6625_(this.ironBarsBeneath + 1)))) {
                ++this.ironBarsBeneath;
            }
            this.ironBarsAbove = 0;
            while (this.ironBarsAbove < 10 && ElectrostaticCompressorBlockEntity.isValidGridBlock(this.nonNullLevel().m_8055_(this.m_58899_().m_6630_(this.ironBarsAbove + 1)))) {
                ++this.ironBarsAbove;
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.maybeLightningStrike();
        if (this.lastRedstoneState != this.rsController.shouldEmit()) {
            this.lastRedstoneState = !this.lastRedstoneState;
            this.updateNeighbours();
        }
        --this.struckByLightningCooldown;
    }

    public int getStrikeChance() {
        int strikeChance = (Integer)ConfigHelper.common().machines.electrostaticLightningChance.get();
        if (this.nonNullLevel().m_46471_()) {
            strikeChance = (int)((double)strikeChance * 0.5);
        }
        if (this.nonNullLevel().m_46470_()) {
            strikeChance = (int)((double)strikeChance * 0.2);
        }
        strikeChance = (int)((float)strikeChance * (1.0f - 0.02f * (float)this.ironBarsAbove));
        return strikeChance;
    }

    private void maybeLightningStrike() {
        Level level = this.nonNullLevel();
        Random rnd = level.f_46441_;
        if (rnd.nextInt(this.getStrikeChance()) == 0) {
            int dist = rnd.nextInt(6);
            float angle = rnd.nextFloat() * (float)Math.PI * 2.0f;
            int x = (int)((float)this.m_58899_().m_123341_() + (float)dist * Mth.m_14031_((float)angle));
            int z = (int)((float)this.m_58899_().m_123343_() + (float)dist * Mth.m_14089_((float)angle));
            for (int y = this.m_58899_().m_123342_() + 5; y > this.m_58899_().m_123342_() - 5; --y) {
                BlockPos hitPos = new BlockPos(x, y, z);
                BlockState state = level.m_8055_(hitPos);
                if (!(state.m_60734_() instanceof ElectrostaticCompressorBlock) && !ElectrostaticCompressorBlockEntity.isValidGridBlock(state)) continue;
                ObjectOpenHashSet gridSet = new ObjectOpenHashSet(500);
                ObjectOpenHashSet compressorSet = new ObjectOpenHashSet(20);
                this.getElectrostaticGrid((Set<BlockPos>)gridSet, (Set<ElectrostaticCompressorBlockEntity>)compressorSet, hitPos);
                LightningBolt bolt = new LightningBolt(EntityType.f_20465_, level);
                bolt.m_6034_((double)x, (double)y, (double)z);
                level.m_7967_((Entity)bolt);
                for (ElectrostaticCompressorBlockEntity compressor : compressorSet) {
                    compressor.onStruckByLightning(compressor, compressorSet.size());
                }
                AABB box = new AABB(this.m_58899_()).m_82377_(16.0, 16.0, 16.0);
                for (LivingEntity entity : level.m_6443_(LivingEntity.class, box, EntitySelector.f_20402_)) {
                    BlockPos pos = entity.m_142538_();
                    if (!gridSet.contains(pos) && !gridSet.contains(pos.m_7495_()) || ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBolt)bolt)) continue;
                    entity.m_8038_((ServerLevel)level, bolt);
                }
                break;
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return dir != Direction.UP;
    }

    private void onStruckByLightning(ElectrostaticCompressorBlockEntity compressor, int divisor) {
        compressor.addAir(200000 / divisor);
        this.struckByLightningCooldown = 10;
        float excessPressure = compressor.getPressure() - compressor.getDangerPressure();
        if (excessPressure > 0.0f) {
            int maxRedirection = 10000 * compressor.ironBarsBeneath;
            int excessAir = (int)(excessPressure * (float)compressor.airHandler.getVolume());
            compressor.addAir(-Math.min(maxRedirection, excessAir));
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public void getElectrostaticGrid(Set<BlockPos> grid, Set<ElectrostaticCompressorBlockEntity> compressors, BlockPos pos) {
        ArrayDeque<BlockPos> pendingPos = new ArrayDeque<BlockPos>(Collections.singleton(pos));
        grid.add(pos);
        this.nonNullLevel().m_141902_(pos, (BlockEntityType)ModBlockEntities.ELECTROSTATIC_COMPRESSOR.get()).ifPresent(compressors::add);
        while (!pendingPos.isEmpty()) {
            BlockPos checkingPos = (BlockPos)pendingPos.pop();
            for (Direction d : DirectionUtil.VALUES) {
                BlockPos newPos = checkingPos.m_142300_(d);
                BlockState state = this.nonNullLevel().m_8055_(newPos);
                if (!ElectrostaticCompressorBlockEntity.isValidGridBlock(state) && state.m_60734_() != ModBlocks.ELECTROSTATIC_COMPRESSOR.get() || grid.size() >= 500 || !grid.add(newPos)) continue;
                if (state.m_60734_() == ModBlocks.ELECTROSTATIC_COMPRESSOR.get()) {
                    this.nonNullLevel().m_141902_(newPos, (BlockEntityType)ModBlockEntities.ELECTROSTATIC_COMPRESSOR.get()).ifPresent(compressors::add);
                }
                pendingPos.push(newPos);
            }
        }
    }

    private static boolean isValidGridBlock(BlockState state) {
        return state.m_204336_(PneumaticCraftTags.Blocks.ELECTROSTATIC_GRID);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ElectrostaticCompressorMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public RedstoneController<ElectrostaticCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }
}

