/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.IFluidTank;

public abstract class AbstractFluidTER<T extends AbstractPneumaticCraftBlockEntity>
implements BlockEntityRenderer<T> {
    AbstractFluidTER(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(T te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (((AbstractPneumaticCraftBlockEntity)te).nonNullLevel().m_46749_(te.m_58899_())) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)TextureAtlas.f_118259_));
            Matrix4f posMat = matrixStack.m_85850_().m_85861_();
            for (TankRenderInfo tankRenderInfo : this.getTanksToRender(te)) {
                AbstractFluidTER.renderFluid(builder, tankRenderInfo, posMat, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public static void renderFluid(VertexConsumer builder, TankRenderInfo tankRenderInfo, Matrix4f posMat, int combinedLight, int combinedOverlay) {
        float v2;
        float v1;
        float u2;
        float u1;
        IFluidTank tank = tankRenderInfo.getTank();
        if (tank.getFluidAmount() == 0) {
            return;
        }
        Fluid fluid = tank.getFluid().getFluid();
        ResourceLocation texture = fluid.getAttributes().getStillTexture(tank.getFluid());
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
        int[] cols = RenderUtils.decomposeColor(fluid.getAttributes().getColor(tank.getFluid()));
        AABB bounds = AbstractFluidTER.getRenderBounds(tank, tankRenderInfo.getBounds());
        float x1 = (float)bounds.f_82288_;
        float x2 = (float)bounds.f_82291_;
        float y1 = (float)bounds.f_82289_;
        float y2 = (float)bounds.f_82292_;
        float z1 = (float)bounds.f_82290_;
        float z2 = (float)bounds.f_82293_;
        double bx1 = bounds.f_82288_ * 16.0;
        double bx2 = bounds.f_82291_ * 16.0;
        double by1 = bounds.f_82289_ * 16.0;
        double by2 = bounds.f_82292_ * 16.0;
        double bz1 = bounds.f_82290_ * 16.0;
        double bz2 = bounds.f_82293_ * 16.0;
        if (tankRenderInfo.shouldRender(Direction.DOWN)) {
            u1 = still.m_118367_(bx1);
            u2 = still.m_118367_(bx2);
            v1 = still.m_118393_(bz1);
            v2 = still.m_118393_(bz2);
            builder.m_85982_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        }
        if (tankRenderInfo.shouldRender(Direction.UP)) {
            u1 = still.m_118367_(bx1);
            u2 = still.m_118367_(bx2);
            v1 = still.m_118393_(bz1);
            v2 = still.m_118393_(bz2);
            builder.m_85982_(posMat, x1, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x1, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (tankRenderInfo.shouldRender(Direction.NORTH)) {
            u1 = still.m_118367_(bx1);
            u2 = still.m_118367_(bx2);
            v1 = still.m_118393_(by1);
            v2 = still.m_118393_(by2);
            builder.m_85982_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_85982_(posMat, x1, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_85982_(posMat, x2, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_85982_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (tankRenderInfo.shouldRender(Direction.SOUTH)) {
            u1 = still.m_118367_(bx1);
            u2 = still.m_118367_(bx2);
            v1 = still.m_118393_(by1);
            v2 = still.m_118393_(by2);
            builder.m_85982_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_85982_(posMat, x2, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_85982_(posMat, x1, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_85982_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (tankRenderInfo.shouldRender(Direction.WEST)) {
            u1 = still.m_118367_(by1);
            u2 = still.m_118367_(by2);
            v1 = still.m_118393_(bz1);
            v2 = still.m_118393_(bz2);
            builder.m_85982_(posMat, x1, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x1, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x1, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x1, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (tankRenderInfo.shouldRender(Direction.EAST)) {
            u1 = still.m_118367_(by1);
            u2 = still.m_118367_(by2);
            v1 = still.m_118393_(bz1);
            v2 = still.m_118393_(bz2);
            builder.m_85982_(posMat, x2, y1, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y2, z1).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y2, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u2, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(posMat, x2, y1, z2).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(u1, v2).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        }
    }

    private static AABB getRenderBounds(IFluidTank tank, AABB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.f_82292_ - tankBounds.f_82289_;
        double y1 = tankBounds.f_82289_;
        double y2 = tankBounds.f_82289_ + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getAttributes().isLighterThanAir()) {
            double yOff = tankBounds.f_82292_ - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AABB(tankBounds.f_82288_, y1, tankBounds.f_82290_, tankBounds.f_82291_, y2, tankBounds.f_82293_);
    }

    static AABB rotateY(AABB in, int rot) {
        return switch (rot) {
            case 90 -> new AABB(1.0 - in.f_82290_, in.f_82289_, in.f_82288_, 1.0 - in.f_82293_, in.f_82292_, in.f_82291_);
            case 180 -> new AABB(1.0 - in.f_82288_, in.f_82289_, 1.0 - in.f_82290_, 1.0 - in.f_82291_, in.f_82292_, 1.0 - in.f_82293_);
            case 270 -> new AABB(in.f_82290_, in.f_82289_, 1.0 - in.f_82288_, in.f_82293_, in.f_82292_, 1.0 - in.f_82291_);
            default -> throw new IllegalArgumentException("rot must be 90, 180 or 270");
        };
    }

    abstract Collection<TankRenderInfo> getTanksToRender(T var1);
}

