/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import org.apache.commons.lang3.Validate;

public enum ArmorUpgradeClientRegistry {
    INSTANCE;

    private List<List<IArmorUpgradeClientHandler<?>>> clientUpgradeHandlers = null;
    private final Map<ResourceLocation, IArmorUpgradeClientHandler<?>> id2HandlerMap = new ConcurrentHashMap();
    private final Map<ResourceLocation, KeyMapping> id2KeyBindMap = new ConcurrentHashMap<ResourceLocation, KeyMapping>();
    private final Map<String, IArmorUpgradeClientHandler<?>> triggerKeyBindMap = new ConcurrentHashMap();

    public static ArmorUpgradeClientRegistry getInstance() {
        return INSTANCE;
    }

    public <T extends IArmorUpgradeHandler<?>> void registerHandler(T handler, IArmorUpgradeClientHandler<T> clientHandler) {
        this.id2HandlerMap.put(handler.getID(), clientHandler);
        clientHandler.getInitialKeyBinding().ifPresent(keyMapping -> this.registerKeyBinding(handler.getID(), (KeyMapping)keyMapping));
        clientHandler.getTriggerKeyBinding().ifPresent(keyMapping -> this.registerTriggerKeybinding(clientHandler, (KeyMapping)keyMapping));
    }

    private void registerKeyBinding(ResourceLocation upgradeID, KeyMapping keyBinding) {
        this.id2KeyBindMap.put(upgradeID, keyBinding);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBinding);
    }

    private void registerTriggerKeybinding(IArmorUpgradeClientHandler<?> clientHandler, KeyMapping keyBinding) {
        this.triggerKeyBindMap.put(keyBinding.m_90860_(), clientHandler);
    }

    public void registerSubKeyBinds() {
        this.id2HandlerMap.values().forEach(clientHandler -> clientHandler.getSubKeybinds().forEach(rl -> this.registerKeyBinding((ResourceLocation)rl, new KeyMapping(IArmorUpgradeHandler.getStringKey(rl), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, -1, clientHandler.getSubKeybindCategory()))));
    }

    public KeyMapping getKeybindingForUpgrade(ResourceLocation upgradeID) {
        return this.id2KeyBindMap.get(upgradeID);
    }

    public <C extends IArmorUpgradeClientHandler<U>, U extends IArmorUpgradeHandler<?>> C getClientHandler(U armorUpgradeHandler, Class<C> clientClass) {
        List<IArmorUpgradeClientHandler<?>> clientHandlers = this.getHandlersForSlot(armorUpgradeHandler.getEquipmentSlot());
        return (C)clientHandlers.get(armorUpgradeHandler.getIndex());
    }

    public IArmorUpgradeClientHandler<?> getClientHandler(ResourceLocation id) {
        return this.id2HandlerMap.get(id);
    }

    public Optional<IArmorUpgradeClientHandler<?>> getTriggeredHandler(KeyMapping keyBinding) {
        return Optional.ofNullable(this.triggerKeyBindMap.get(keyBinding.m_90860_()));
    }

    public List<IArmorUpgradeClientHandler<?>> getHandlersForSlot(EquipmentSlot slot) {
        if (this.clientUpgradeHandlers == null) {
            this.initHandlerLists();
        }
        return this.clientUpgradeHandlers.get(slot.m_20749_());
    }

    private void initHandlerLists() {
        if (!ArmorUpgradeRegistry.getInstance().isFrozen()) {
            throw new IllegalStateException("armor upgrade registry is not frozen yet!");
        }
        if (this.clientUpgradeHandlers != null) {
            throw new IllegalStateException("handler lists already inited!?");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EquipmentSlot ignored : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            builder.add(new ArrayList());
        }
        this.clientUpgradeHandlers = builder.build();
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeHandler<?> handler : ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot)) {
                IArmorUpgradeClientHandler<?> clientHandler = this.id2HandlerMap.get(handler.getID());
                Validate.notNull(clientHandler, (String)("Null client-handler for upgrade handler '" + handler.getID() + "'! Did you forget to register it?"), (Object[])new Object[0]);
                this.clientUpgradeHandlers.get(slot.m_20749_()).add(clientHandler);
            }
        }
        this.refreshConfig();
    }

    public void refreshConfig() {
        if (this.clientUpgradeHandlers == null) {
            return;
        }
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeClientHandler<?> renderHandler : this.getHandlersForSlot(slot)) {
                renderHandler.initConfig();
            }
        }
    }
}

