/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.math.NumberUtils;

public class WidgetTextFieldNumber
extends WidgetTextField {
    public int minValue = Integer.MIN_VALUE;
    public int maxValue = Integer.MAX_VALUE;
    private int decimals;
    private double fineAdjust = 1.0;
    private double coarseAdjust = 1000.0;

    public WidgetTextFieldNumber(Font fontRenderer, int x, int y, int width, int height) {
        super(fontRenderer, x, y, width, height);
        this.setValue(0);
        this.m_94153_(input -> this.decimals == 0 ? PneumaticCraftUtils.isInteger(input) : PneumaticCraftUtils.isNumber(input));
    }

    public WidgetTextFieldNumber setRange(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public WidgetTextFieldNumber setDecimals(int decimals) {
        this.decimals = decimals;
        return this;
    }

    public WidgetTextFieldNumber setValue(int value) {
        this.m_94144_(Integer.toString(Mth.m_14045_((int)value, (int)this.minValue, (int)this.maxValue)));
        return this;
    }

    public WidgetTextFieldNumber setValue(double value) {
        this.m_94144_(PneumaticCraftUtils.roundNumberTo(Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue), this.decimals));
        return this;
    }

    public int getIntValue() {
        return Mth.m_14045_((int)NumberUtils.toInt((String)this.m_94155_()), (int)this.minValue, (int)this.maxValue);
    }

    public double getDoubleValue() {
        return PneumaticCraftUtils.roundNumberToDouble(Mth.m_14008_((double)NumberUtils.toDouble((String)this.m_94155_()), (double)this.minValue, (double)this.maxValue), this.decimals);
    }

    public WidgetTextFieldNumber setAdjustments(double fineAdjust, double coarseAdjust) {
        this.fineAdjust = fineAdjust;
        this.coarseAdjust = coarseAdjust;
        return this;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double adj;
        double d = adj = ClientUtils.hasShiftDown() ? this.coarseAdjust : this.fineAdjust;
        if (this.decimals > 0) {
            this.setValue(this.getDoubleValue() + (delta > 0.0 ? adj : -adj));
        } else {
            int curVal = this.getIntValue();
            if (curVal == 1 && adj % 10.0 == 0.0) {
                adj -= 1.0;
            }
            this.setValue((double)curVal + (delta > 0.0 ? adj : -adj));
        }
        return true;
    }
}

