/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.items.ItemHandlerHelper;

public class StackedIngredient
extends Ingredient {
    public static final StackedIngredient EMPTY = new StackedIngredient(Stream.empty());

    private StackedIngredient(Stream<? extends Ingredient.Value> itemLists) {
        super(itemLists);
    }

    public static Ingredient fromTag(TagKey<Item> tag, int count) {
        return StackedIngredient.fromItemListStream(Stream.of(new StackedTagList(tag, count)));
    }

    public static Ingredient fromStacks(ItemStack ... stacks) {
        return StackedIngredient.fromItemListStream(Arrays.stream(stacks).map(StackedItemList::new));
    }

    public static Ingredient fromItems(int count, ItemLike ... itemsIn) {
        return StackedIngredient.fromItemListStream(Arrays.stream(itemsIn).map(itemProvider -> new StackedItemList(new ItemStack(itemProvider, count))));
    }

    public static Ingredient fromIngredient(int count, Ingredient wrappedIngredient) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (ItemStack stack : wrappedIngredient.m_43908_()) {
            l.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)count));
        }
        return StackedIngredient.fromStacks(l.toArray(new ItemStack[0]));
    }

    public static StackedIngredient fromItemListStream(Stream<? extends Ingredient.Value> stream) {
        StackedIngredient ingredient = new StackedIngredient(stream);
        return ingredient.m_43947_() ? EMPTY : ingredient;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean test(@Nullable ItemStack checkingStack) {
        if (checkingStack == null || checkingStack.m_41619_()) {
            return super.test(checkingStack);
        }
        return Arrays.stream(this.m_43908_()).anyMatch(stack -> stack.m_41720_() == checkingStack.m_41720_() && stack.m_41613_() <= checkingStack.m_41613_());
    }

    private static Ingredient.Value deserializeItemListWithCount(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
            Item item = (Item)Registry.f_122827_.m_6612_(resourcelocation1).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + resourcelocation1 + "'"));
            int count = json.has("count") ? GsonHelper.m_13927_((JsonObject)json, (String)"count") : 1;
            return new Ingredient.ItemValue(new ItemStack((ItemLike)item, count));
        }
        if (json.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)resourcelocation);
            int count = json.has("count") ? GsonHelper.m_13927_((JsonObject)json, (String)"count") : 1;
            return new StackedTagList((TagKey<Item>)tagKey, count);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static class StackedTagList
    implements Ingredient.Value {
        private final TagKey<Item> tagKey;
        private final int count;

        public StackedTagList(TagKey<Item> tagIn, int count) {
            this.tagKey = tagIn;
            this.count = count;
        }

        public Collection<ItemStack> m_6223_() {
            ArrayList list = Lists.newArrayList();
            Registry.f_122827_.m_206058_(this.tagKey).forEach(h -> list.add(new ItemStack((ItemLike)h.m_203334_(), this.count)));
            if (list.size() == 0 && !((Boolean)ForgeConfig.SERVER.treatEmptyTagsAsAir.get()).booleanValue()) {
                list.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)new TextComponent("Empty Tag: " + this.tagKey.f_203868_())));
            }
            return list;
        }

        public JsonObject m_6544_() {
            JsonObject json = new JsonObject();
            json.addProperty("type", Serializer.ID.toString());
            json.addProperty("tag", this.tagKey.f_203868_().toString());
            json.addProperty("count", (Number)this.count);
            return json;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<StackedIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:stacked_item");

        public StackedIngredient parse(FriendlyByteBuf buffer) {
            return StackedIngredient.fromItemListStream(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(buffer.m_130242_()));
        }

        public StackedIngredient parse(JsonObject json) {
            return StackedIngredient.fromItemListStream(Stream.of(StackedIngredient.deserializeItemListWithCount(json)));
        }

        public void write(FriendlyByteBuf buffer, StackedIngredient ingredient) {
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }
    }

    public static class StackedItemList
    implements Ingredient.Value {
        private final ItemStack itemStack;

        public StackedItemList(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public Collection<ItemStack> m_6223_() {
            return Collections.singletonList(this.itemStack);
        }

        public JsonObject m_6544_() {
            JsonObject json = new JsonObject();
            json.addProperty("type", Serializer.ID.toString());
            json.addProperty("item", this.itemStack.m_41720_().getRegistryName().toString());
            json.addProperty("count", (Number)this.itemStack.m_41613_());
            return json;
        }
    }
}

