/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.util;

import com.almostreliable.lazierae2.core.TypeEnums;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public final class TextUtil {
    private static final Locale LOCALE = Locale.getDefault();
    private static final DecimalFormat DF = (DecimalFormat)NumberFormat.getInstance(LOCALE).clone();
    private static final String[] UNITS = new String[]{"", "k", "M", "G", "T", "P"};
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{}");

    private TextUtil() {
    }

    public static String f(String input, Object ... args) {
        for (Object arg : args) {
            input = PLACEHOLDER.matcher(input).replaceFirst(arg.toString());
        }
        for (int i = 0; i < args.length; ++i) {
            input = input.replace("{" + i + "}", args[i].toString());
        }
        return input;
    }

    public static ResourceLocation getRL(String key) {
        return new ResourceLocation("lazierae2", key);
    }

    public static String translateAsString(TypeEnums.TRANSLATE_TYPE type, String key) {
        return TextUtil.translate(type, key, new ChatFormatting[0]).getString();
    }

    public static TranslatableComponent translate(TypeEnums.TRANSLATE_TYPE type, String key, ChatFormatting ... color) {
        TranslatableComponent output = new TranslatableComponent(TextUtil.getTranslationKey(type, key));
        return color.length == 0 ? output : (TranslatableComponent)output.m_130940_(color[0]);
    }

    public static String formatEnergy(Number energy, int minPlaces, int maxPlaces, boolean extended, boolean suffix) {
        if (extended) {
            return TextUtil.formatNumber(energy, minPlaces, maxPlaces) + (suffix ? " FE" : "");
        }
        int numberOfDigits = energy.intValue() == 0 ? 0 : (int)(1.0 + Math.floor(Math.log10(Math.abs(energy.doubleValue()))));
        int base10Exponent = numberOfDigits < 4 ? 0 : 3 * ((numberOfDigits - 1) / 3);
        double normalized = energy.doubleValue() / Math.pow(10.0, base10Exponent);
        return TextUtil.formatNumber(normalized, minPlaces, maxPlaces) + (suffix ? TextUtil.f(" {}FE", UNITS[base10Exponent / 3]) : "");
    }

    static TextComponent colorize(String input, ChatFormatting color) {
        return (TextComponent)new TextComponent(input).m_130940_(color);
    }

    private static String formatNumber(Number number, int minPlaces, int maxPlaces) {
        DF.setRoundingMode(RoundingMode.HALF_UP);
        DF.setMinimumFractionDigits(minPlaces);
        DF.setMaximumFractionDigits(maxPlaces);
        return DF.format(number);
    }

    private static String getTranslationKey(TypeEnums.TRANSLATE_TYPE type, String key) {
        return String.format("%s.%s.%s", type.toString().toLowerCase(), "lazierae2", key);
    }
}

