/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.recipe.type;

import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.recipe.property.IRecipeInputProvider;
import com.almostreliable.lazierae2.recipe.property.RecipeInputIngred;
import com.almostreliable.lazierae2.recipe.property.RecipeOutputStack;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ProcessorRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<ProcessorRecipe> {
    private final ProcessorType processorType;

    public ProcessorRecipeSerializer(ProcessorType processorType) {
        this.processorType = processorType;
    }

    public ProcessorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        RecipeOutputStack output = new RecipeOutputStack(ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output")));
        NonNullList inputs = NonNullList.m_122779_();
        if (this.processorType.getInputSlots() == 1) {
            inputs.add((Object)RecipeInputIngred.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"input")));
        } else {
            GsonHelper.m_13933_((JsonObject)json, (String)"input").forEach(jsonInput -> inputs.add((Object)RecipeInputIngred.fromJson(jsonInput.getAsJsonObject())));
        }
        int processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)this.processorType.getBaseProcessTime());
        int energyCost = GsonHelper.m_13824_((JsonObject)json, (String)"energy_cost", (int)this.processorType.getBaseEnergyCost());
        return this.processorType.getRecipeFactory().create(recipeId, this.processorType, List.of(), output, (NonNullList<IRecipeInputProvider>)inputs, processTime, energyCost);
    }

    @Nullable
    public ProcessorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        RecipeOutputStack output = new RecipeOutputStack(buffer.m_130267_());
        NonNullList inputs = NonNullList.m_122779_();
        int size = this.processorType.getInputSlots() == 1 ? 1 : buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            inputs.add((Object)RecipeInputIngred.fromNetwork(buffer));
        }
        int processTime = buffer.readInt();
        int energyCost = buffer.readInt();
        return this.processorType.getRecipeFactory().create(recipeId, this.processorType, List.of(), output, (NonNullList<IRecipeInputProvider>)inputs, processTime, energyCost);
    }

    public void toNetwork(FriendlyByteBuf buffer, ProcessorRecipe recipe) {
        buffer.m_130055_(recipe.m_8043_());
        if (this.processorType.getInputSlots() == 3) {
            buffer.m_130130_(recipe.getInputs().size());
        }
        recipe.getInputs().forEach(input -> input.toNetwork(buffer));
        buffer.writeInt(recipe.getProcessTime());
        buffer.writeInt(recipe.getEnergyCost());
    }
}

