/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.recipe.builder;

import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.recipe.IngredientWithCount;
import com.almostreliable.lazierae2.recipe.builder.FinishedProcessorRecipe;
import com.almostreliable.lazierae2.recipe.property.IRecipeInputProvider;
import com.almostreliable.lazierae2.recipe.property.IRecipeOutputProvider;
import com.almostreliable.lazierae2.recipe.property.RecipeInputIngred;
import com.almostreliable.lazierae2.recipe.property.RecipeInputResource;
import com.almostreliable.lazierae2.recipe.property.RecipeOutputResource;
import com.almostreliable.lazierae2.recipe.property.RecipeOutputStack;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

public final class ProcessorRecipeBuilder {
    private final ProcessorType recipeType;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final Set<String> loadedModIDs = new HashSet<String>();
    private final IRecipeOutputProvider output;
    private final NonNullList<IRecipeInputProvider> inputs = NonNullList.m_122779_();
    private int processTime;
    private int energyCost;

    private ProcessorRecipeBuilder(ProcessorType recipeType, ItemLike output, int outputCount) {
        this.recipeType = recipeType;
        this.output = new RecipeOutputStack(new ItemStack(output, outputCount));
    }

    private ProcessorRecipeBuilder(ProcessorType recipeType, String output, int outputCount) {
        this.recipeType = recipeType;
        String[] outputSplit = output.split(":");
        ResourceLocation outputId = new ResourceLocation(outputSplit[0], outputSplit[1]);
        this.output = new RecipeOutputResource(outputId, outputCount);
    }

    public static ProcessorRecipeBuilder aggregator(ItemLike output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.AGGREGATOR, output, outputCount);
    }

    public static ProcessorRecipeBuilder aggregator(ItemLike output) {
        return ProcessorRecipeBuilder.aggregator(output, 1);
    }

    public static ProcessorRecipeBuilder aggregator(String output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.AGGREGATOR, output, outputCount);
    }

    public static ProcessorRecipeBuilder aggregator(String output) {
        return ProcessorRecipeBuilder.aggregator(output, 1);
    }

    public static ProcessorRecipeBuilder etcher(ItemLike output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.ETCHER, output, outputCount);
    }

    public static ProcessorRecipeBuilder etcher(ItemLike output) {
        return ProcessorRecipeBuilder.etcher(output, 1);
    }

    public static ProcessorRecipeBuilder etcher(String output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.ETCHER, output, outputCount);
    }

    public static ProcessorRecipeBuilder etcher(String output) {
        return ProcessorRecipeBuilder.etcher(output, 1);
    }

    public static ProcessorRecipeBuilder grinder(ItemLike output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.GRINDER, output, outputCount);
    }

    public static ProcessorRecipeBuilder grinder(ItemLike output) {
        return ProcessorRecipeBuilder.grinder(output, 1);
    }

    public static ProcessorRecipeBuilder grinder(String output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.GRINDER, output, outputCount);
    }

    public static ProcessorRecipeBuilder grinder(String output) {
        return ProcessorRecipeBuilder.grinder(output, 1);
    }

    public static ProcessorRecipeBuilder infuser(ItemLike output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.INFUSER, output, outputCount);
    }

    public static ProcessorRecipeBuilder infuser(ItemLike output) {
        return ProcessorRecipeBuilder.infuser(output, 1);
    }

    public static ProcessorRecipeBuilder infuser(String output, int outputCount) {
        return new ProcessorRecipeBuilder(ProcessorType.INFUSER, output, outputCount);
    }

    public static ProcessorRecipeBuilder infuser(String output) {
        return ProcessorRecipeBuilder.infuser(output, 1);
    }

    public ProcessorRecipeBuilder input(IngredientWithCount ... inputs) {
        for (IngredientWithCount input : inputs) {
            this.inputs.add((Object)new RecipeInputIngred(input));
        }
        return this;
    }

    public ProcessorRecipeBuilder input(Ingredient input, int count) {
        return this.input(new IngredientWithCount(input, count));
    }

    public ProcessorRecipeBuilder input(String input, int count) {
        String[] inputSplit = input.split(":");
        if (!List.of("minecraft", "lazierae2", "ae2").contains(inputSplit[0])) {
            this.modLoaded(inputSplit[0]);
        }
        ResourceLocation inputId = new ResourceLocation(inputSplit[0], inputSplit[1]);
        this.inputs.add((Object)new RecipeInputResource(inputId, count));
        return this;
    }

    public ProcessorRecipeBuilder input(Ingredient input) {
        return this.input(input, 1);
    }

    public ProcessorRecipeBuilder input(String input) {
        return this.input(input, 1);
    }

    public ProcessorRecipeBuilder input(ItemLike input) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
    }

    public ProcessorRecipeBuilder input(ItemLike input, int count) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), count);
    }

    public ProcessorRecipeBuilder input(TagKey<Item> input) {
        return this.input(Ingredient.m_204132_(input));
    }

    public ProcessorRecipeBuilder input(TagKey<Item> input, int count) {
        return this.input(Ingredient.m_204132_(input), count);
    }

    public ProcessorRecipeBuilder processingTime(int ticks) {
        this.processTime = ticks;
        return this;
    }

    public ProcessorRecipeBuilder energyCost(int energy) {
        this.energyCost = energy;
        return this;
    }

    public void build(Consumer<? super FinishedRecipe> consumer, String suffix) {
        String namespace = this.output.id().m_135827_().replace("minecraft", "lazierae2");
        String outputId = this.output.id().m_135815_();
        String path = TextUtil.f("{}/{}{}", this.recipeType.getId(), outputId, suffix);
        if (!namespace.equals("lazierae2")) {
            if (!namespace.equals("ae2")) {
                this.modLoaded(namespace);
            }
            path = TextUtil.f("compat/{}/{}", namespace, path);
        }
        consumer.accept(new FinishedProcessorRecipe(this.build(TextUtil.getRL(path))));
    }

    public void build(Consumer<? super FinishedRecipe> consumer) {
        this.build(consumer, "");
    }

    public ProcessorRecipe build(ResourceLocation recipeId) {
        return this.recipeType.getRecipeFactory().create(recipeId, this.recipeType, this.conditions, this.output, this.inputs, this.processTime, this.energyCost);
    }

    private void modLoaded(String ... modIds) {
        for (String id : modIds) {
            if (this.loadedModIDs.contains(id)) continue;
            this.conditions.add((ICondition)new ModLoadedCondition(id));
            this.loadedModIDs.add(id);
        }
    }
}

