/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.network.sync;

import com.almostreliable.lazierae2.network.sync.IDataHandler;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public abstract class GenericDataHandler<T>
implements IDataHandler {
    private final Supplier<? extends T> getter;
    private final Consumer<? super T> setter;
    private T oldValue;

    protected GenericDataHandler(Supplier<? extends T> getter, Consumer<? super T> setter) {
        this.getter = getter;
        this.setter = setter;
        this.oldValue = getter.get();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        T currentValue = this.getter.get();
        this.oldValue = currentValue;
        this.handleEncoding(buffer, currentValue);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.setter.accept(this.handleDecoding(buffer));
    }

    @Override
    public boolean hasChanged() {
        return !Objects.equals(this.oldValue, this.getter.get());
    }

    protected abstract void handleEncoding(FriendlyByteBuf var1, T var2);

    @Nullable
    protected abstract T handleDecoding(FriendlyByteBuf var1);
}

