/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.network.packets;

import com.almostreliable.lazierae2.content.GenericMenu;
import com.almostreliable.lazierae2.content.requester.RequesterEntity;
import com.almostreliable.lazierae2.content.requester.RequesterMenu;
import com.almostreliable.lazierae2.network.ClientToServerPacket;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class RequestCountPacket
extends ClientToServerPacket<RequestCountPacket> {
    private int slot;
    private long value;

    public RequestCountPacket(int slot, long value) {
        this.slot = slot;
        this.value = value;
    }

    public RequestCountPacket() {
    }

    @Override
    public void encode(RequestCountPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.slot);
        buffer.writeLong(packet.value);
    }

    @Override
    public RequestCountPacket decode(FriendlyByteBuf buffer) {
        RequestCountPacket packet = new RequestCountPacket();
        packet.slot = buffer.readInt();
        packet.value = buffer.readLong();
        return packet;
    }

    @Override
    protected void handlePacket(RequestCountPacket packet, @Nullable ServerPlayer player) {
        if (player != null && player.f_36096_ instanceof RequesterMenu) {
            Object entity = ((GenericMenu)player.f_36096_).entity;
            if (!(entity instanceof RequesterEntity)) {
                return;
            }
            RequesterEntity requester = (RequesterEntity)((Object)entity);
            Level level = requester.m_58904_();
            if (level == null || !level.m_46749_(requester.m_58899_())) {
                return;
            }
            requester.craftRequests.get(packet.slot).updateCount(packet.value);
        }
    }
}

