/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.gui.control;

import com.almostreliable.lazierae2.content.requester.RequesterMenu;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.gui.RequesterScreen;
import com.almostreliable.lazierae2.gui.widgets.GenericButton;
import com.almostreliable.lazierae2.gui.widgets.ToggleButton;
import com.almostreliable.lazierae2.network.PacketHandler;
import com.almostreliable.lazierae2.network.packets.RequestBatchPacket;
import com.almostreliable.lazierae2.network.packets.RequestCountPacket;
import com.almostreliable.lazierae2.network.packets.RequestStatePacket;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public final class RequestControl {
    private static final int WIDGETS_PER_CONTROL = 6;
    public final RequesterScreen screen;
    private final int slots;
    private final Control[] controls;

    public RequestControl(RequesterScreen screen, int slots) {
        this.screen = screen;
        this.slots = slots;
        this.controls = new Control[slots];
        for (int slot = 0; slot < slots; ++slot) {
            this.controls[slot] = new Control(slot);
        }
    }

    public AbstractWidget[] init() {
        AbstractWidget[] widgets = new AbstractWidget[this.slots * 6];
        for (int control = 0; control < this.controls.length; ++control) {
            AbstractWidget[] controlWidgets = this.controls[control].init();
            System.arraycopy(controlWidgets, 0, widgets, control * 6, controlWidgets.length);
        }
        return widgets;
    }

    public void refreshControlBoxes(int slot) {
        Control control = this.controls[slot];
        assert (control.countBox != null && control.batchBox != null);
        control.countBox.setValueFromEntity();
        control.batchBox.setValueFromEntity();
    }

    private final class Control {
        private static final int BUTTON_SIZE = 13;
        private final int slot;
        @Nullable
        private CountBox countBox;
        @Nullable
        private BatchBox batchBox;

        private Control(int slot) {
            this.slot = slot;
        }

        private AbstractWidget[] init() {
            this.countBox = new CountBox();
            this.batchBox = new BatchBox();
            StateBox stateButton = new StateBox(RequestControl.this.screen);
            ProgressionDisplay progressionDisplay = new ProgressionDisplay();
            return new AbstractWidget[]{stateButton, this.countBox, this.countBox.submitButton, this.batchBox, this.batchBox.submitButton, progressionDisplay};
        }

        private final class CountBox
        extends TextBox {
            private static final int POS_X = 47;

            private CountBox() {
                super(47);
            }

            @Override
            protected void setupTooltip() {
                this.tooltip.title("count.title", new Supplier[0]).blank(Screen::m_96638_).line(Screen::m_96638_, "count.description", new Supplier[0]);
                super.setupTooltip();
            }

            @Override
            protected void switchFocus() {
                BatchBox nextBox = RequestControl.this.controls[Control.this.slot].batchBox;
                if (nextBox == null) {
                    return;
                }
                this.m_94178_(false);
                nextBox.m_94178_(true);
                RequestControl.this.screen.m_7522_((GuiEventListener)nextBox);
            }

            @Override
            protected void sendToServer() {
                PacketHandler.CHANNEL.sendToServer((Object)new RequestCountPacket(Control.this.slot, this.getValueAsLong()));
            }

            @Override
            protected long getEntityValue() {
                return ((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestCount(Control.this.slot);
            }
        }

        private final class BatchBox
        extends TextBox {
            private static final int POS_X = 110;

            private BatchBox() {
                super(110);
            }

            @Override
            protected void setupTooltip() {
                this.tooltip.title("batch.title", new Supplier[0]).blank(Screen::m_96638_).line(Screen::m_96638_, "batch.description", new Supplier[0]);
                super.setupTooltip();
            }

            @Override
            protected void switchFocus() {
                CountBox nextBox = RequestControl.this.controls[Control.this.slot == RequestControl.this.controls.length - 1 ? 0 : Control.this.slot + 1].countBox;
                if (nextBox == null) {
                    return;
                }
                this.m_94178_(false);
                nextBox.m_94178_(true);
                RequestControl.this.screen.m_7522_((GuiEventListener)nextBox);
            }

            @Override
            protected void sendToServer() {
                PacketHandler.CHANNEL.sendToServer((Object)new RequestBatchPacket(Control.this.slot, this.getValueAsLong()));
            }

            @Override
            protected void validateAndSubmit() {
                if (this.getValueAsLong() <= 0L) {
                    return;
                }
                super.validateAndSubmit();
            }

            @Override
            protected long getEntityValue() {
                return ((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestBatch(Control.this.slot);
            }
        }

        private final class StateBox
        extends ToggleButton {
            private static final String TEXTURE_ID = "state";
            private static final int POS_X = 8;
            private static final int POS_Y = 8;
            private static final int BOX_SIZE = 14;
            private static final int GAP = 6;
            private static final List<Component> TOOLTIP = GuiUtil.Tooltip.builder().line("state", new Supplier[0]).build();

            private StateBox(RequesterScreen screen) {
                super(screen, 8, Control.this.slot * 20 + 8, 14, 14, TEXTURE_ID, () -> ((RequesterMenu)screen.m_6262_()).getRequestState(com$almostreliable$lazierae2$gui$control$RequestControl$Control$this.slot));
            }

            public void m_7428_(PoseStack stack, int mX, int mY) {
                this.screen.m_96597_(stack, TOOLTIP, mX, mY);
            }

            @Override
            protected void clickHandler() {
                PacketHandler.CHANNEL.sendToServer((Object)new RequestStatePacket(Control.this.slot, !this.pressed.getAsBoolean()));
            }
        }

        private final class ProgressionDisplay
        extends AbstractWidget {
            private static final int POS_X = 46;
            private static final int POS_Y = 20;
            private static final int WIDTH = 123;
            private static final int HEIGHT = 4;
            private static final int GAP = 16;
            private final GuiUtil.Tooltip tooltip;

            private ProgressionDisplay() {
                super(RequestControl.this.screen.getGuiLeft() + 46, RequestControl.this.screen.getGuiTop() + Control.this.slot * 20 + 20, 123, 4, TextComponent.f_131282_);
                this.tooltip = this.setupTooltip();
            }

            public void m_6303_(PoseStack stack, int mX, int mY, float partial) {
                ProgressionDisplay.m_93172_((PoseStack)stack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)(this.f_93620_ + 123 - 2), (int)(this.f_93621_ + 4 - 2), (int)GuiUtil.fillColorAlpha(this.getProgressionColor().m_126665_()));
            }

            protected boolean m_7972_(int pButton) {
                return false;
            }

            public void m_7428_(PoseStack stack, int mX, int mY) {
                RequestControl.this.screen.m_96597_(stack, this.tooltip.build(), mX, mY);
            }

            public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
                this.m_168802_(pNarrationElementOutput);
            }

            private GuiUtil.Tooltip setupTooltip() {
                return GuiUtil.Tooltip.builder().title("status.title", new Supplier[0]).blank().conditional(current -> current.condition(() -> this.getProgressionColor() != ChatFormatting.DARK_GRAY).then(GuiUtil.Tooltip.builder().keyEnum("status.current", TypeEnums.TRANSLATE_TYPE.REQUEST_STATUS, () -> ((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestStatus(Control.this.slot))).otherwise(GuiUtil.Tooltip.builder().line("status.none", ChatFormatting.WHITE, new Supplier[0]))).blank().conditional(advanced -> advanced.condition(Screen::m_96638_).then(GuiUtil.Tooltip.builder().lineEnum(TypeEnums.TRANSLATE_TYPE.REQUEST_STATUS, this.getProgressionColor(TypeEnums.PROGRESSION_TYPE.IDLE), TypeEnums.PROGRESSION_TYPE.IDLE).line("status.idle", new Supplier[0]).blank().lineEnum(TypeEnums.TRANSLATE_TYPE.REQUEST_STATUS, this.getProgressionColor(TypeEnums.PROGRESSION_TYPE.LINK), TypeEnums.PROGRESSION_TYPE.LINK).line("status.link", new Supplier[0]).blank().lineEnum(TypeEnums.TRANSLATE_TYPE.REQUEST_STATUS, this.getProgressionColor(TypeEnums.PROGRESSION_TYPE.EXPORT), TypeEnums.PROGRESSION_TYPE.EXPORT).line("status.export", new Supplier[0])).otherwise(GuiUtil.Tooltip.builder().shiftForInfo()));
            }

            private ChatFormatting getProgressionColor(TypeEnums.PROGRESSION_TYPE status) {
                return switch (status) {
                    case TypeEnums.PROGRESSION_TYPE.IDLE -> ChatFormatting.DARK_GREEN;
                    case TypeEnums.PROGRESSION_TYPE.LINK -> ChatFormatting.YELLOW;
                    case TypeEnums.PROGRESSION_TYPE.EXPORT -> ChatFormatting.DARK_PURPLE;
                    default -> throw new IllegalStateException("Impossible client state: " + status);
                };
            }

            private ChatFormatting getProgressionColor() {
                if (!((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestState(Control.this.slot) || ((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestCount(Control.this.slot) == 0L) {
                    return ChatFormatting.DARK_GRAY;
                }
                TypeEnums.PROGRESSION_TYPE status = ((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestStatus(Control.this.slot);
                return this.getProgressionColor(status);
            }
        }

        private abstract class TextBox
        extends EditBox {
            private static final int POS_Y = 7;
            private static final int WIDTH = 44;
            private static final int HEIGHT = 11;
            private static final int GAP = 9;
            final SubmitButton submitButton;
            final GuiUtil.Tooltip tooltip;

            private TextBox(int x) {
                super(RequestControl.this.screen.getMinecraft().f_91062_, RequestControl.this.screen.getGuiLeft() + x + 2, RequestControl.this.screen.getGuiTop() + Control.this.slot * 20 + 7 + 2, 44, 11, TextComponent.f_131282_);
                this.submitButton = new SubmitButton(RequestControl.this.screen, x + 44 + 2, Control.this.slot * 20 + 7 - 1);
                this.applyBoxDefaults();
                this.tooltip = GuiUtil.Tooltip.builder();
                this.setupTooltip();
            }

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                if (keyCode == InputConstants.m_84851_((String)"key.keyboard.enter").m_84873_()) {
                    this.validateAndSubmit();
                    this.m_94178_(false);
                    RequestControl.this.screen.m_7522_(null);
                    return true;
                }
                if (keyCode == InputConstants.m_84851_((String)"key.keyboard.tab").m_84873_()) {
                    this.validateAndSubmit();
                    this.switchFocus();
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }

            protected void setupTooltip() {
                this.tooltip.blank().shiftForInfo().conditional(focused -> focused.condition(() -> ((TextBox)this).m_93696_()).then(GuiUtil.Tooltip.builder().hotkeyAction("key.keyboard.tab", "focus.switch.action", new Supplier[0]).hotkeyAction("key.keyboard.enter", "submit.action", new Supplier[0])).otherwise(GuiUtil.Tooltip.builder().clickAction("focus.action", new Supplier[0])));
            }

            protected abstract void switchFocus();

            protected abstract void sendToServer();

            protected void validateAndSubmit() {
                if (((RequesterMenu)RequestControl.this.screen.m_6262_()).getRequestStack(Control.this.slot).m_41619_()) {
                    this.setValueFromEntity();
                    return;
                }
                this.setValueFromLong(this.getValueAsLong());
            }

            void setValueFromEntity() {
                this.m_94144_(String.valueOf(this.getEntityValue()));
            }

            private void applyBoxDefaults() {
                this.m_94182_(false);
                this.m_94202_(0xFFFFFF);
                this.m_94153_(text -> StringUtils.isNumeric((CharSequence)text) || text.isEmpty());
                this.m_94199_(6);
                this.setValueFromEntity();
            }

            long getValueAsLong() {
                try {
                    return Long.parseLong(this.m_94155_());
                }
                catch (NumberFormatException e) {
                    return this.getEntityValue();
                }
            }

            protected abstract long getEntityValue();

            public boolean m_198029_() {
                return this.f_93622_;
            }

            public void m_7428_(PoseStack stack, int mX, int mY) {
                RequestControl.this.screen.m_96597_(stack, this.tooltip.build(), mX, mY);
            }

            private void setValueFromLong(long value) {
                long oldValue = this.getEntityValue();
                this.m_94144_(String.valueOf(value));
                if (value != oldValue) {
                    this.sendToServer();
                }
            }

            private final class SubmitButton
            extends GenericButton {
                private static final String TEXTURE_ID = "submit";
                private static final List<Component> TOOLTIP = GuiUtil.Tooltip.builder().line("submit", new Supplier[0]).build();

                private SubmitButton(RequesterScreen screen, int x, int y) {
                    super(screen, x, y, 13, 13, TEXTURE_ID);
                }

                public void m_7428_(PoseStack stack, int mX, int mY) {
                    this.screen.m_96597_(stack, TOOLTIP, mX, mY);
                }

                @Override
                public void m_6303_(PoseStack stack, int mX, int mY, float partial) {
                    if (this.f_93622_) {
                        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
                        SubmitButton.m_93133_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)13.0f, (int)this.f_93618_, (int)this.f_93619_, (int)13, (int)this.getTextureHeight());
                    } else {
                        super.m_6303_(stack, mX, mY, partial);
                    }
                }

                @Override
                protected void clickHandler() {
                    TextBox.this.validateAndSubmit();
                }

                @Override
                protected int getTextureWidth() {
                    return 13;
                }

                @Override
                protected int getTextureHeight() {
                    return 26;
                }
            }
        }
    }
}

