/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.data.client;

import appeng.init.client.InitItemModelsProperties;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.util.GameUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelData
extends ItemModelProvider {
    public ItemModelData(DataGenerator gen, ExistingFileHelper fileHelper) {
        super(gen, "lazierae2", fileHelper);
    }

    protected void registerModels() {
        this.withBlockParent((Supplier<? extends Block>)Setup.Blocks.AGGREGATOR);
        this.withBlockParent((Supplier<? extends Block>)Setup.Blocks.ETCHER);
        this.withBlockParent((Supplier<? extends Block>)Setup.Blocks.GRINDER);
        this.withBlockParent((Supplier<? extends Block>)Setup.Blocks.INFUSER);
        this.withBlockParent((Supplier<? extends Block>)Setup.Blocks.REQUESTER);
        this.genericItem((Supplier<? extends Item>)Setup.Items.COAL_DUST);
        this.genericItem((Supplier<? extends Item>)Setup.Items.CARB_FLUIX_DUST);
        this.genericItem((Supplier<? extends Item>)Setup.Items.FLUIX_STEEL);
        this.genericItem((Supplier<? extends Item>)Setup.Items.RESONATING_CRYSTAL);
        this.crystalSeed((Supplier<? extends Item>)Setup.Items.RESONATING_SEED);
        this.genericItem((Supplier<? extends Item>)Setup.Items.RESONATING_DUST);
        this.genericItem((Supplier<? extends Item>)Setup.Items.LOGIC_UNIT);
        this.genericItem((Supplier<? extends Item>)Setup.Items.GROWTH_CORE);
        this.genericItem((Supplier<? extends Item>)Setup.Items.UNIVERSAL_PRESS);
        this.genericItem((Supplier<? extends Item>)Setup.Items.PARALLEL_PRINTED);
        this.genericItem((Supplier<? extends Item>)Setup.Items.PARALLEL_PROCESSOR);
    }

    private void withBlockParent(Supplier<? extends Block> block) {
        String id = GameUtil.getIdFromBlock(block.get());
        ResourceLocation parentLocation = TextUtil.getRL(TextUtil.f("block/{}", id));
        this.withExistingParent(id, parentLocation);
    }

    private void crystalSeed(Supplier<? extends Item> item) {
        String id = GameUtil.getIdFromItem(item.get());
        ModelBuilder<?> stageOneModel = this.getModelFile(id + "_2");
        ModelBuilder<?> stageTwoModel = this.getModelFile(id + "_3");
        this.getLayerZeroFromParent(id).override().predicate(InitItemModelsProperties.GROWTH_PREDICATE_ID, 0.333f).model(stageOneModel).end().override().predicate(InitItemModelsProperties.GROWTH_PREDICATE_ID, 0.666f).model(stageTwoModel).end();
    }

    private ItemModelBuilder getLayerZeroFromParent(String id) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id)).parent(this.getItemGenerated())).texture("layer0", TextUtil.f("item/{}", id));
    }

    private void genericItem(Supplier<? extends Item> item) {
        this.getLayerZeroFromParent(GameUtil.getIdFromItem(item.get()));
    }

    private ModelBuilder<?> getModelFile(String id) {
        return this.getLayerZeroFromParent(id);
    }

    private ModelFile getItemGenerated() {
        return this.getExistingFile(this.mcLoc("item/generated"));
    }
}

