/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.requester;

import appeng.api.config.FuzzyMode;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.almostreliable.lazierae2.content.requester.RequesterEntity;
import com.almostreliable.lazierae2.content.requester.RequesterInventory;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class StorageManager
implements IStorageWatcherNode,
INBTSerializable<CompoundTag> {
    private final Storage[] storages;
    private final RequesterEntity owner;
    @Nullable
    private IStackWatcher stackWatcher;

    StorageManager(RequesterEntity owner, int slots) {
        this.owner = owner;
        this.storages = new Storage[slots];
    }

    public Storage get(int slot) {
        if (this.storages[slot] == null) {
            this.storages[slot] = new Storage();
        }
        return this.storages[slot];
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.stackWatcher = newWatcher;
        this.resetWatcher();
    }

    public void onStackChange(AEKey what, long amount) {
        for (int slot = 0; slot < this.storages.length; ++slot) {
            if (!this.owner.craftRequests.matches(slot, what)) continue;
            this.get((int)slot).knownAmount = amount;
            this.get((int)slot).pendingAmount = 0L;
        }
    }

    public long computeDelta(int slot) {
        RequesterInventory.Request request = this.owner.craftRequests.get(slot);
        if (request.getStack().m_41619_()) {
            return 0L;
        }
        long storedAmount = this.get((int)slot).knownAmount + this.get((int)slot).pendingAmount;
        if (storedAmount < request.getCount()) {
            return request.getBatch();
        }
        return 0L;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int slot = 0; slot < this.storages.length; ++slot) {
            tag.m_128365_(String.valueOf(slot), (Tag)this.get(slot).serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        for (int slot = 0; slot < this.storages.length; ++slot) {
            this.get(slot).deserializeNBT(tag.m_128469_(String.valueOf(slot)));
        }
    }

    void dropContents() {
        assert (this.owner.m_58904_() != null);
        for (Storage storage : this.storages) {
            AEKey itemType;
            if (storage == null || !((itemType = storage.getItemType()) instanceof AEItemKey)) continue;
            AEItemKey aeItem = (AEItemKey)itemType;
            long amount = storage.getBufferAmount() + storage.pendingAmount;
            if (amount <= 0L) continue;
            for (long i = amount; i > 0L; i -= 64L) {
                ItemStack stack = aeItem.toStack((int)Math.min(i, 64L));
                this.owner.m_58904_().m_7967_((Entity)new ItemEntity(this.owner.m_58904_(), (double)this.owner.m_58899_().m_123341_() + 0.5, (double)this.owner.m_58899_().m_123342_() + 0.5, (double)this.owner.m_58899_().m_123343_() + 0.5, stack));
            }
        }
    }

    void clear(int slot) {
        this.get((int)slot).knownAmount = -1L;
        this.calcSlotAmount(slot);
        this.resetWatcher();
    }

    private void populateWatcher(IStackWatcher watcher) {
        for (int slot = 0; slot < this.storages.length; ++slot) {
            if (this.owner.craftRequests.get(slot).getStack().m_41619_()) continue;
            watcher.add((AEKey)AEItemKey.of((ItemStack)this.owner.craftRequests.get(slot).getStack()));
        }
    }

    private void resetWatcher() {
        if (this.stackWatcher != null) {
            this.stackWatcher.reset();
            this.populateWatcher(this.stackWatcher);
        }
    }

    private void calcSlotAmount(int slot) {
        RequesterInventory.Request request = this.owner.craftRequests.get(slot);
        if (request.getStack().m_41619_()) {
            return;
        }
        GenericStack genericStack = GenericStack.fromItemStack((ItemStack)request.getStack());
        if (genericStack == null) {
            return;
        }
        this.get((int)slot).knownAmount = this.owner.getMainNodeGrid().getStorageService().getInventory().getAvailableStacks().get(genericStack.what());
    }

    public static class Storage
    implements INBTSerializable<CompoundTag> {
        @Nullable
        private AEKey itemType;
        private long bufferAmount;
        private long pendingAmount;
        private long knownAmount = -1L;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.itemType != null) {
                tag.m_128365_("item_type", (Tag)this.itemType.toTagGeneric());
            }
            tag.m_128356_("buffer_amount", this.bufferAmount);
            tag.m_128356_("pending_amount", this.pendingAmount);
            tag.m_128356_("known_amount", this.knownAmount);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128441_("item_type")) {
                this.itemType = AEKey.fromTagGeneric((CompoundTag)tag.m_128469_("item_type"));
            }
            this.bufferAmount = tag.m_128454_("buffer_amount");
            this.pendingAmount = tag.m_128454_("pending_amount");
            this.knownAmount = tag.m_128454_("known_amount");
        }

        public boolean compute(long inserted) {
            this.pendingAmount = inserted;
            this.bufferAmount = this.getBufferAmount() - inserted;
            if (this.bufferAmount == 0L) {
                this.itemType = null;
            }
            return this.bufferAmount > 0L;
        }

        void update(AEKey itemType, long bufferAmount) {
            if (this.itemType != null && !itemType.fuzzyEquals(this.itemType, FuzzyMode.IGNORE_ALL)) {
                throw new IllegalArgumentException("itemType mismatch");
            }
            this.itemType = itemType;
            this.bufferAmount += bufferAmount;
        }

        @Nullable
        public AEKey getItemType() {
            return this.itemType;
        }

        public long getBufferAmount() {
            return this.itemType == null ? 0L : this.bufferAmount;
        }

        public long getKnownAmount() {
            return this.knownAmount;
        }
    }
}

