/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.requester;

import com.almostreliable.lazierae2.content.GenericMenu;
import com.almostreliable.lazierae2.content.requester.RequesterEntity;
import com.almostreliable.lazierae2.content.requester.RequesterInventory;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.inventory.FakeSlot;
import com.almostreliable.lazierae2.network.sync.handler.EnumDataHandler;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class RequesterMenu
extends GenericMenu<RequesterEntity> {
    private static final int SLOT_GAP = 2;
    private final RequesterInventory requesterInventory;

    public RequesterMenu(int windowId, RequesterEntity entity, Inventory menuInventory) {
        super((MenuType)Setup.Menus.REQUESTER.get(), windowId, entity, menuInventory);
        this.requesterInventory = entity.craftRequests;
        this.setupContainerInventory();
        this.setupPlayerInventory();
        this.syncData();
    }

    public ItemStack m_7648_(Player player, int slot) {
        FakeSlot fakeSlot;
        if (slot < this.requesterInventory.getSlots() || slot > this.requesterInventory.getSlots() + 36) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_38853_(slot).m_7993_();
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int targetSlotIndex = this.requesterInventory.firstAvailableSlot();
        if (targetSlotIndex == -1) {
            return ItemStack.f_41583_;
        }
        Slot targetSlot = this.m_38853_(targetSlotIndex);
        if (!(targetSlot instanceof FakeSlot) || (fakeSlot = (FakeSlot)targetSlot).isLocked()) {
            return ItemStack.f_41583_;
        }
        fakeSlot.m_5852_(stack);
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        FakeSlot fakeSlot;
        Slot slot;
        if (slotId >= 0 && slotId < this.requesterInventory.getSlots() && (slot = this.m_38853_(slotId)) instanceof FakeSlot && !(fakeSlot = (FakeSlot)slot).isLocked()) {
            this.handleClick(dragType, clickType, slot);
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public boolean getRequestState(int slot) {
        return ((RequesterEntity)this.entity).craftRequests.get(slot).getState();
    }

    public ItemStack getRequestStack(int slot) {
        return ((RequesterEntity)this.entity).craftRequests.get(slot).getStack();
    }

    public long getRequestCount(int slot) {
        return ((RequesterEntity)this.entity).craftRequests.get(slot).getCount();
    }

    public long getRequestBatch(int slot) {
        return ((RequesterEntity)this.entity).craftRequests.get(slot).getBatch();
    }

    public TypeEnums.PROGRESSION_TYPE getRequestStatus(int slot) {
        return ((RequesterEntity)this.entity).getProgression(slot).type();
    }

    @Override
    protected void setupContainerInventory() {
        for (int i = 0; i < this.requesterInventory.getSlots(); ++i) {
            this.m_38897_((Slot)new FakeSlot(this, (IItemHandler)this.requesterInventory, i, 26, 7 + i * 18 + i * 2));
        }
    }

    @Override
    protected int getSlotY() {
        return 129;
    }

    private void syncData() {
        int slot = 0;
        while (slot < this.requesterInventory.getSlots()) {
            int finalSlot = slot++;
            this.sync.addDataHandler(this.requesterInventory.get(finalSlot));
            this.sync.addDataHandler(new EnumDataHandler(() -> this.getRequestStatus(finalSlot).translateToClient(), value -> ((RequesterEntity)this.entity).setClientProgression(finalSlot, (TypeEnums.PROGRESSION_TYPE)((Object)value)), (Enum[])TypeEnums.PROGRESSION_TYPE.values()));
        }
    }

    private void handleClick(int dragType, ClickType clickType, Slot slot) {
        ItemStack hand = this.m_142621_();
        if (clickType == ClickType.PICKUP) {
            if (hand.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
                return;
            }
            if (dragType == 0) {
                slot.m_5852_(hand.m_41777_());
            } else {
                ItemStack stack = hand.m_41777_();
                stack.m_41764_(1);
                slot.m_5852_(stack);
            }
        } else if (clickType == ClickType.QUICK_MOVE) {
            slot.m_5852_(ItemStack.f_41583_);
        }
    }
}

