/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.requester;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.almostreliable.lazierae2.content.requester.RequesterEntity;
import com.almostreliable.lazierae2.network.ClientHandler;
import com.almostreliable.lazierae2.network.sync.IDataHandler;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public final class RequesterInventory
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final RequesterEntity entity;
    private final Request[] requests;

    RequesterInventory(RequesterEntity entity, int slots) {
        this.entity = entity;
        this.requests = new Request[slots];
        for (int i = 0; i < slots; ++i) {
            this.requests[i] = new Request(i);
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (this.entity.m_58904_() == null) {
            return;
        }
        this.validateSlot(slot);
        if (this.entity.m_58904_().f_46443_) {
            this.get(slot).updateStackClient(stack);
        } else {
            this.get(slot).updateStack(stack);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.getSlots(); ++i) {
            tag.m_128365_(String.valueOf(i), (Tag)this.get(i).serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.get(i).deserializeNBT(tag.m_128469_(String.valueOf(i)));
        }
    }

    public Request get(int slot) {
        return this.requests[slot];
    }

    int firstAvailableSlot() {
        for (int slot = 0; slot < this.requests.length; ++slot) {
            Request request = this.get(slot);
            if (!request.stack.m_41619_()) continue;
            return slot;
        }
        return -1;
    }

    boolean matches(int slot, AEKey what) {
        return what.matches(GenericStack.fromItemStack((ItemStack)this.get((int)slot).stack));
    }

    private void validateSlot(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new IllegalArgumentException("Slot " + slot + " is out of range");
        }
    }

    public int getSlots() {
        return this.requests.length;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.get((int)slot).stack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        throw new UnsupportedOperationException();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public final class Request
    implements INBTSerializable<CompoundTag>,
    IDataHandler {
        private final int slot;
        private boolean state = true;
        private ItemStack stack = ItemStack.f_41583_;
        private long count;
        private long batch = 1L;
        private boolean changed;

        private Request(int slot) {
            this.slot = slot;
        }

        public GenericStack toGenericStack(long count) {
            ItemStack stackCopy = this.stack.m_41777_();
            return new GenericStack((AEKey)Objects.requireNonNull(AEItemKey.of((ItemStack)stackCopy)), count);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("state", this.state);
            tag.m_128365_("stack", (Tag)this.stack.serializeNBT());
            tag.m_128356_("count", this.count);
            tag.m_128356_("batch", this.batch);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.state = tag.m_128471_("state");
            this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
            this.count = tag.m_128454_("count");
            this.batch = tag.m_128454_("batch");
        }

        public void updateState(boolean state) {
            if (this.state != state) {
                this.state = state;
                RequesterInventory.this.entity.m_6596_();
                this.changed = true;
            }
        }

        public void updateCount(long count) {
            ItemStack oldStack = this.stack;
            long oldCount = this.count;
            long oldBatch = this.batch;
            if (this.stack.m_41619_() || count <= 0L) {
                this.resetSlot();
            } else {
                this.count = count;
            }
            if (!oldStack.m_41656_(this.stack) || oldCount != this.count || oldBatch != this.batch) {
                RequesterInventory.this.entity.m_6596_();
                this.changed = true;
            }
        }

        public void updateBatch(long batch) {
            long oldBatch = this.batch;
            long l = this.batch = batch <= 0L ? 1L : batch;
            if (oldBatch != this.batch) {
                RequesterInventory.this.entity.m_6596_();
                this.changed = true;
            }
        }

        public String toString() {
            return "Request[state=" + this.state + ", stack=" + this.stack + ", count=" + this.count + ", batch=" + this.batch + "]";
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.slot);
            buffer.writeBoolean(this.state);
            buffer.writeItemStack(this.stack, true);
            buffer.writeLong(this.count);
            buffer.writeLong(this.batch);
            this.changed = false;
        }

        @Override
        public void decode(FriendlyByteBuf buffer) {
            if (this.slot != buffer.readInt()) {
                throw new IllegalStateException("Slot mismatch");
            }
            this.state = buffer.readBoolean();
            this.stack = buffer.m_130267_();
            this.count = buffer.readLong();
            this.batch = buffer.readLong();
            ClientHandler.updateRequestGui(this.slot);
        }

        @Override
        public boolean hasChanged() {
            return this.changed;
        }

        private void updateStackClient(ItemStack stack) {
            this.stack = stack;
        }

        private void updateStack(ItemStack stack) {
            ItemStack oldStack = this.stack;
            if (stack.m_41619_()) {
                if (!oldStack.m_41619_()) {
                    this.resetSlot();
                }
                return;
            }
            if (oldStack.m_41656_(stack)) {
                if (this.count != (long)stack.m_41613_()) {
                    this.count = stack.m_41613_();
                    this.changed = true;
                }
                return;
            }
            this.count = stack.m_41613_();
            this.stack = stack;
            stack.m_41764_(1);
            this.batch = 1L;
            this.stackChanged();
        }

        private void stackChanged() {
            RequesterInventory.this.entity.getStorageManager().clear(this.slot);
            RequesterInventory.this.entity.m_6596_();
            this.changed = true;
        }

        private void resetSlot() {
            ItemStack oldStack = this.stack;
            this.stack = ItemStack.f_41583_;
            this.count = 0L;
            this.batch = 1L;
            if (!oldStack.m_41619_()) {
                this.stackChanged();
            }
        }

        public boolean getState() {
            return this.state;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public long getCount() {
            return this.count;
        }

        long getBatch() {
            return this.batch;
        }

        public boolean isRequesting() {
            return this.state && !this.stack.m_41619_();
        }
    }
}

