/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.requester;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.helpers.MachineSource;
import com.almostreliable.lazierae2.content.GenericBlock;
import com.almostreliable.lazierae2.content.GenericEntity;
import com.almostreliable.lazierae2.content.requester.RequesterInventory;
import com.almostreliable.lazierae2.content.requester.RequesterMenu;
import com.almostreliable.lazierae2.content.requester.StorageManager;
import com.almostreliable.lazierae2.core.Config;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.progression.ClientState;
import com.almostreliable.lazierae2.progression.CraftingLinkState;
import com.almostreliable.lazierae2.progression.IProgressionState;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RequesterEntity
extends GenericEntity
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity,
IGridTickable,
ICraftingRequester {
    private static final int SLOTS = 6;
    public final RequesterInventory craftRequests;
    private final IProgressionState[] progressions;
    private final IManagedGridNode mainNode;
    private final IActionSource actionSource;
    private final StorageManager storageManager;
    private TickRateModulation currentTickRateModulation = TickRateModulation.IDLE;

    public RequesterEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Setup.Entities.REQUESTER.get(), pos, state);
        this.actionSource = new MachineSource((IActionHost)this);
        this.craftRequests = new RequesterInventory(this, 6);
        this.storageManager = new StorageManager(this, 6);
        this.progressions = new IProgressionState[6];
        Arrays.fill(this.progressions, IProgressionState.IDLE);
        this.mainNode = this.setupMainNode();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mainNode.loadFromNBT(tag);
        if (tag.m_128441_("craft_requests")) {
            this.craftRequests.deserializeNBT(tag.m_128469_("craft_requests"));
        }
        if (tag.m_128441_("storage_manager")) {
            this.storageManager.deserializeNBT(tag.m_128469_("storage_manager"));
        }
        if (tag.m_128441_("progression_states")) {
            this.loadStates(tag.m_128469_("progression_states"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.mainNode.saveToNBT(tag);
        tag.m_128365_("craft_requests", (Tag)this.craftRequests.serializeNBT());
        tag.m_128365_("storage_manager", (Tag)this.storageManager.serializeNBT());
        tag.m_128365_("progression_states", (Tag)this.saveStates());
    }

    public void m_7651_() {
        super.m_7651_();
        this.mainNode.destroy();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.mainNode.destroy();
    }

    public void m_6339_() {
        super.m_6339_();
        GridHelper.onFirstTick((BlockEntity)this, this::onReady);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new RequesterMenu(windowId, this, inventory);
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        IGridNode node = this.mainNode.getNode();
        if (node != null && node.isExposedOnSide(dir)) {
            return node;
        }
        return null;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.mainNode.isActive()) {
            return TickRateModulation.IDLE;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return TickRateModulation.IDLE;
        }
        if (this.handleProgressions()) {
            this.m_6596_();
        }
        this.updateActivityState();
        return this.currentTickRateModulation;
    }

    public IProgressionState getProgression(int slot) {
        return this.progressions[slot];
    }

    public void setClientProgression(int slot, TypeEnums.PROGRESSION_TYPE type) {
        this.progressions[slot] = new ClientState(type);
    }

    @Override
    protected void playerDestroy(boolean creative) {
        assert (this.f_58857_ != null);
        this.storageManager.dropContents();
        if (creative) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)Setup.Blocks.REQUESTER.get());
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
    }

    private void onReady(RequesterEntity requester) {
        this.mainNode.create(this.f_58857_, this.f_58858_);
    }

    private void loadStates(CompoundTag tag) {
        for (int slot = 0; slot < this.progressions.length; ++slot) {
            if (!tag.m_128441_(String.valueOf(slot))) continue;
            CompoundTag stateTag = tag.m_128469_(String.valueOf(slot));
            ICraftingLink link = StorageHelper.loadCraftingLink((CompoundTag)stateTag, (ICraftingRequester)this);
            this.progressions[slot] = new CraftingLinkState(link);
        }
    }

    private CompoundTag saveStates() {
        CompoundTag tag = new CompoundTag();
        for (int slot = 0; slot < this.progressions.length; ++slot) {
            IProgressionState state = this.progressions[slot];
            if (!(state instanceof CraftingLinkState)) continue;
            CraftingLinkState cls = (CraftingLinkState)state;
            CompoundTag stateTag = new CompoundTag();
            cls.link().writeToNBT(stateTag);
            tag.m_128365_(String.valueOf(slot), (Tag)stateTag);
        }
        return tag;
    }

    private boolean handleProgressions() {
        boolean changed = false;
        TickRateModulation tickRateModulation = TickRateModulation.IDLE;
        for (int slot = 0; slot < this.progressions.length; ++slot) {
            TickRateModulation resultTickRateModulation;
            IProgressionState state = this.progressions[slot];
            IProgressionState result = this.handleProgression(slot);
            if (!Objects.equals(state, result)) {
                changed = true;
            }
            if ((resultTickRateModulation = result.getTickRateModulation()).ordinal() > tickRateModulation.ordinal()) {
                tickRateModulation = resultTickRateModulation;
            }
            this.progressions[slot] = result;
        }
        this.currentTickRateModulation = tickRateModulation;
        return changed;
    }

    private IProgressionState handleProgression(int slot) {
        IProgressionState state = this.progressions[slot];
        this.progressions[slot] = state.handle(this, slot);
        if (this.progressions[slot].type() != TypeEnums.PROGRESSION_TYPE.IDLE && !Objects.equals(this.progressions[slot], state)) {
            return this.handleProgression(slot);
        }
        return this.progressions[slot];
    }

    private void updateActivityState() {
        for (IProgressionState progression : this.progressions) {
            if (progression.type() != TypeEnums.PROGRESSION_TYPE.EXPORT && progression.type() != TypeEnums.PROGRESSION_TYPE.LINK) continue;
            this.changeActivityState(true);
            return;
        }
        this.changeActivityState(false);
    }

    private IManagedGridNode setupMainNode() {
        EnumSet<Direction> exposedSides = EnumSet.allOf(Direction.class);
        exposedSides.remove(this.m_58900_().m_61143_((Property)GenericBlock.FACING));
        IManagedGridNode node = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE).addService(IStorageWatcherNode.class, (IGridNodeService)this.storageManager).addService(ICraftingRequester.class, (IGridNodeService)this).addService(IGridTickable.class, (IGridNodeService)this).setVisualRepresentation((ItemLike)Setup.Blocks.REQUESTER.get()).setInWorldNode(true).setTagName("proxy").setIdlePowerUsage(((Double)Config.COMMON.requesterIdleEnergy.get()).doubleValue()).setExposedOnSides(exposedSides);
        if (((Boolean)Config.COMMON.requesterRequireChannel.get()).equals(Boolean.TRUE)) {
            node.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        }
        return node;
    }

    public IActionSource getActionSource() {
        return this.actionSource;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.m_6596_();
        } else {
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return (ImmutableSet)Arrays.stream(this.progressions).filter(CraftingLinkState.class::isInstance).map(state -> ((CraftingLinkState)state).link()).collect(ImmutableSet.toImmutableSet());
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        for (int slot = 0; slot < this.progressions.length; ++slot) {
            CraftingLinkState cls;
            IProgressionState state = this.progressions[slot];
            if (!(state instanceof CraftingLinkState) || !(cls = (CraftingLinkState)state).link().equals(link)) continue;
            if (!mode.isSimulate()) {
                this.storageManager.get(slot).update(what, amount);
            }
            return amount;
        }
        throw new IllegalStateException("No CraftingLinkState found");
    }

    public void jobStateChange(ICraftingLink link) {
    }

    public IGrid getMainNodeGrid() {
        IGrid grid = this.mainNode.getGrid();
        Objects.requireNonNull(grid, "RequesterEntity was not fully initialized - Grid is null");
        return grid;
    }
}

