/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import com.almostreliable.lazierae2.content.GenericMenu;
import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorInventory;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.inventory.OutputSlot;
import com.almostreliable.lazierae2.inventory.UpgradeSlot;
import com.almostreliable.lazierae2.network.sync.handler.BooleanDataHandler;
import com.almostreliable.lazierae2.network.sync.handler.IntegerDataHandler;
import com.almostreliable.lazierae2.util.GameUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ProcessorMenu
extends GenericMenu<ProcessorEntity> {
    private ProcessorInventory processorInventory;

    public ProcessorMenu(int id, ProcessorEntity entity, Inventory menuInventory) {
        super((MenuType)Setup.Menus.PROCESSOR.get(), id, entity, menuInventory);
        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            this.processorInventory = (ProcessorInventory)inv;
            this.setupContainerInventory();
        });
        this.setupPlayerInventory();
        this.syncData();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return stack;
        }
        ItemStack slotStack = slot.m_7993_();
        stack = slotStack.m_41777_();
        if (index < this.processorInventory.getSlots()) {
            if (!this.m_38903_(slotStack, this.processorInventory.getSlots(), this.processorInventory.getSlots() + 36, false)) {
                return ItemStack.f_41583_;
            }
        } else if (GameUtil.isValidUpgrade(slotStack)) {
            if (!this.m_38903_(slotStack, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            slotStack = this.processorInventory.insertToInputs(slotStack);
        }
        if (slotStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_5852_(slotStack);
            slot.m_6654_();
        }
        if (slotStack.m_41613_() == stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, slotStack);
        return stack;
    }

    public boolean hasUpgrades() {
        return this.getUpgradeCount() > 0;
    }

    @Override
    protected void setupContainerInventory() {
        int inputSlots = this.processorInventory.getInputSlots();
        this.m_38897_((Slot)new UpgradeSlot(this, (IItemHandler)this.processorInventory, 0, 8, 50));
        this.m_38897_((Slot)new OutputSlot((IItemHandler)this.processorInventory, 1, 116, 29));
        if (inputSlots == 1) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.processorInventory, 2, 44, 29));
        } else if (inputSlots == 3) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.processorInventory, 2, 44, 8));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.processorInventory, 3, 44, 29));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.processorInventory, 4, 44, 50));
        } else {
            throw new IllegalArgumentException(TextUtil.f("Invalid input slot getCount: {}", inputSlots));
        }
    }

    @Override
    protected int getSlotY() {
        return 72;
    }

    private void syncData() {
        this.sync.addDataHandler(new BooleanDataHandler(((ProcessorEntity)this.entity)::isAutoExtracting, (Consumer<? super Boolean>)((Consumer<Boolean>)((ProcessorEntity)this.entity)::setAutoExtract)));
        this.sync.addDataHandler(new IntegerDataHandler(((ProcessorEntity)this.entity)::getProgress, (Consumer<? super Integer>)((Consumer<Integer>)((ProcessorEntity)this.entity)::setProgress)));
        this.sync.addDataHandler(new IntegerDataHandler(((ProcessorEntity)this.entity)::getProcessTime, (Consumer<? super Integer>)((Consumer<Integer>)((ProcessorEntity)this.entity)::setProcessTime)));
        this.sync.addDataHandler(new IntegerDataHandler(((ProcessorEntity)this.entity)::getRecipeTime, (Consumer<? super Integer>)((Consumer<Integer>)((ProcessorEntity)this.entity)::setRecipeTime)));
        this.sync.addDataHandler(new IntegerDataHandler(((ProcessorEntity)this.entity)::getEnergyCost, (Consumer<? super Integer>)((Consumer<Integer>)((ProcessorEntity)this.entity)::setEnergyCost)));
        this.sync.addDataHandler(new IntegerDataHandler(((ProcessorEntity)this.entity)::getRecipeEnergy, (Consumer<? super Integer>)((Consumer<Integer>)((ProcessorEntity)this.entity)::setRecipeEnergy)));
        this.sync.addDataHandler(((ProcessorEntity)this.entity).energy);
        this.sync.addDataHandler(((ProcessorEntity)this.entity).sideConfig);
    }

    public int getUpgradeCount() {
        return this.processorInventory.getUpgradeCount();
    }

    public int getEnergyStored() {
        return ((ProcessorEntity)this.entity).energy.getEnergyStored();
    }

    public void setEnergyStored(int energy) {
        ((ProcessorEntity)this.entity).energy.setEnergy(energy);
    }

    public int getEnergyCapacity() {
        return ((ProcessorEntity)this.entity).energy.getMaxEnergyStored();
    }
}

