/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import appeng.core.definitions.AEItems;
import com.almostreliable.lazierae2.content.GenericEntity;
import com.almostreliable.lazierae2.content.processor.EnergyHandler;
import com.almostreliable.lazierae2.content.processor.ProcessorBlock;
import com.almostreliable.lazierae2.content.processor.ProcessorInventory;
import com.almostreliable.lazierae2.content.processor.ProcessorMenu;
import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.content.processor.SideConfiguration;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.recipe.property.IRecipeInputProvider;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.almostreliable.lazierae2.util.GameUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntToDoubleFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ProcessorEntity
extends GenericEntity {
    private static final int AUTO_EXTRACT_RATE = 10;
    public final SideConfiguration sideConfig;
    public final EnergyHandler energy;
    private final ProcessorInventory inventory;
    private final LazyOptional<ProcessorInventory> inventoryCap;
    private final LazyOptional<EnergyHandler> energyCap;
    private final Map<Direction, LazyOptional<IItemHandler>> autoExtractCache = new EnumMap<Direction, LazyOptional<IItemHandler>>(Direction.class);
    private ProcessorRecipe recipeCache;
    private boolean autoExtract;
    private int progress;
    private int energyCost;
    private int processTime;
    private int recipeTime;
    private int recipeEnergy;
    private int recipeMultiplier;

    public ProcessorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Setup.Entities.PROCESSOR.get(), pos, state);
        this.inventory = new ProcessorInventory(this);
        this.inventoryCap = LazyOptional.of(() -> this.inventory);
        this.energy = new EnergyHandler(this);
        this.energyCap = LazyOptional.of(() -> this.energy);
        this.sideConfig = new SideConfiguration(this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        }
        if (tag.m_128441_("energy")) {
            this.energy.deserializeNBT(tag.m_128469_("energy"));
        }
        if (tag.m_128441_("side_config")) {
            this.sideConfig.deserializeNBT(tag.m_128469_("side_config"));
        }
        if (tag.m_128441_("auto_extract")) {
            this.autoExtract = tag.m_128471_("auto_extract");
        }
        if (tag.m_128441_("progress")) {
            this.progress = tag.m_128451_("progress");
        }
        if (tag.m_128441_("process_time")) {
            this.processTime = tag.m_128451_("process_time");
        }
        if (tag.m_128441_("recipe_time")) {
            this.recipeTime = tag.m_128451_("recipe_time");
        }
        if (tag.m_128441_("energy_cost")) {
            this.energyCost = tag.m_128451_("energy_cost");
        }
        if (tag.m_128441_("recipe_energy")) {
            this.recipeEnergy = tag.m_128451_("recipe_energy");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("side_config", (Tag)this.sideConfig.serializeNBT());
        tag.m_128379_("auto_extract", this.autoExtract);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("process_time", this.processTime);
        tag.m_128405_("recipe_time", this.recipeTime);
        tag.m_128405_("energy_cost", this.energyCost);
        tag.m_128405_("recipe_energy", this.recipeEnergy);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menuID, Inventory inventory, Player player) {
        return new ProcessorMenu(menuID, this, inventory);
    }

    public void recalculateEnergyCapacity() {
        int upgradeBuffer;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int baseBuffer = this.getProcessorType().getBaseEnergyBuffer();
        int newCapacity = baseBuffer + (upgradeBuffer = this.getProcessorType().getEnergyBufferAdd()) * this.inventory.getUpgradeCount();
        if (newCapacity != this.energy.getMaxEnergyStored()) {
            this.energy.setCapacity(newCapacity);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventory.invalidate();
        this.inventoryCap.invalidate();
        this.energyCap.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (!this.f_58859_) {
            if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (direction == null) {
                    return this.inventoryCap.cast();
                }
                TypeEnums.IO_SETTING setting = this.sideConfig.get(direction);
                if (setting != TypeEnums.IO_SETTING.OFF) {
                    return this.inventory.getInventoryCap(setting).cast();
                }
            } else if (cap.equals((Object)CapabilityEnergy.ENERGY)) {
                return this.energyCap.cast();
            }
        }
        return super.getCapability(cap, direction);
    }

    public double calculateMultiplier(IntToDoubleFunction multiplierList) {
        int upgradeCount = this.inventory.getUpgradeCount();
        return upgradeCount == 0 ? 1.0 : multiplierList.applyAsDouble(upgradeCount);
    }

    public void insertUpgrades(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int maxUpgrades = this.getProcessorType().getUpgradeSlots();
        int currentUpgrades = this.inventory.getUpgradeCount();
        int inserted = Math.min(stack.m_41613_(), maxUpgrades - currentUpgrades);
        if (inserted > 0) {
            this.inventory.setStackInSlot(0, AEItems.SPEED_CARD.stack(currentUpgrades + inserted));
            stack.m_41774_(inserted);
            if (stack.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            } else {
                player.m_21008_(hand, stack);
            }
        }
    }

    @Override
    protected void playerDestroy(boolean creative) {
        assert (this.f_58857_ != null);
        this.inventory.dropContents(creative);
        if (creative) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        if (this.inventory.getUpgradeCount() > 0) {
            tag.m_128365_("upgrades", (Tag)this.inventory.serializeUpgrades());
        }
        if (this.energy.getEnergyStored() > 0) {
            tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        }
        if (this.sideConfig.isConfigured()) {
            tag.m_128365_("side_config", (Tag)this.sideConfig.serializeNBT());
        }
        if (this.autoExtract) {
            tag.m_128379_("auto_extract", true);
        }
        ItemStack stack = new ItemStack(this.getProcessorType().getItemProvider());
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
    }

    void tick() {
        ProcessorRecipe recipe;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.autoExtract && this.f_58857_.m_46467_() % 10L == 0L) {
            this.autoExtract();
        }
        if ((recipe = this.getRecipe()) == null) {
            return;
        }
        this.recipeEnergy = recipe.getEnergyCost();
        this.recipeTime = recipe.getProcessTime();
        Map<Integer, Integer> recipeInputSlots = this.getInputSlotsForRecipe(recipe);
        double energyCostExact = this.calculateEnergyCost(recipe);
        this.energyCost = (int)energyCostExact;
        double processTimeExact = this.calculateProcessTime(recipe);
        this.processTime = processTimeExact < 1.0 ? 1 : (int)Math.ceil(processTimeExact);
        int n = this.recipeMultiplier = processTimeExact <= 0.5 ? (int)(1.0 / processTimeExact) : 1;
        if (this.canWork(recipe, energyCostExact, recipeInputSlots)) {
            this.doWork(energyCostExact);
        } else {
            this.changeActivityState(false);
        }
        if (this.progress >= this.processTime) {
            this.finishWork(recipe, recipeInputSlots);
        }
    }

    void playerPlace(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("upgrades")) {
            this.inventory.deserializeUpgrades(tag.m_128469_("upgrades"));
        }
        if (tag.m_128441_("energy")) {
            this.energy.deserializeNBT(tag.m_128469_("energy"));
        }
        if (tag.m_128441_("side_config")) {
            this.sideConfig.deserializeNBT(tag.m_128469_("side_config"));
        }
        if (tag.m_128441_("auto_extract")) {
            this.autoExtract = tag.m_128471_("auto_extract");
        }
    }

    private void finishWork(ProcessorRecipe recipe, Map<Integer, Integer> recipeInputSlots) {
        int produced;
        this.inventory.shrinkInputSlots(recipeInputSlots, this.recipeMultiplier);
        if (this.inventory.getStackInOutput().m_41619_()) {
            ItemStack outputStack = recipe.m_5874_(this.inventory.toVanilla());
            outputStack.m_41764_(outputStack.m_41613_() * this.recipeMultiplier);
            this.inventory.setStackInOutput(outputStack);
        } else {
            this.inventory.getStackInOutput().m_41769_(recipe.m_8043_().m_41613_() * this.recipeMultiplier);
        }
        this.progress = 0;
        this.m_6596_();
        if (this.processTime < 10 && (produced = recipe.m_8043_().m_41613_() * this.recipeMultiplier) + this.inventory.getStackInOutput().m_41613_() > this.inventory.getStackLimit(1, recipe.m_8043_())) {
            this.autoExtract();
        }
    }

    private void doWork(double energyCostExact) {
        this.changeActivityState(true);
        this.energy.setEnergy((int)((long)this.energy.getEnergyStored() - Math.round(energyCostExact * (double)this.recipeMultiplier / (double)this.processTime)));
        ++this.progress;
        this.m_6596_();
    }

    private boolean canWork(ProcessorRecipe recipe, double energyCostExact, Map<Integer, Integer> recipeInputSlots) {
        this.recipeMultiplierByEnergy(energyCostExact);
        if (this.recipeMultiplier == 0) {
            return false;
        }
        ItemStack outputStack = this.inventory.getStackInOutput();
        ItemStack recipeResult = recipe.m_8043_();
        if (!outputStack.m_41619_() && !outputStack.m_41656_(recipeResult)) {
            return false;
        }
        int maxOutputSpace = outputStack.m_41619_() ? this.inventory.getSlotLimit(1) : this.inventory.getStackLimit(1, recipeResult) - outputStack.m_41613_();
        this.recipeMultiplierByOutput(maxOutputSpace, recipeResult.m_41613_());
        if (this.recipeMultiplier == 0) {
            return false;
        }
        int smallestInputCount = -1;
        for (Map.Entry<Integer, Integer> input : recipeInputSlots.entrySet()) {
            int count = this.inventory.getStackInSlot(input.getKey()).m_41613_() / input.getValue();
            if (smallestInputCount != -1 && count >= smallestInputCount) continue;
            smallestInputCount = count;
        }
        if (smallestInputCount == -1) {
            throw new IllegalStateException("No slots to shrink");
        }
        this.recipeMultiplier = Math.min(this.recipeMultiplier, smallestInputCount);
        return this.recipeMultiplier != 0;
    }

    @NotNull
    private Map<Integer, Integer> getInputSlotsForRecipe(ProcessorRecipe recipe) {
        HashMap<Integer, Integer> slotsToShrink = new HashMap<Integer, Integer>();
        block0: for (IRecipeInputProvider input : recipe.getInputs()) {
            for (int slot = 2; slot < this.inventory.getSlots(); ++slot) {
                if (!input.ingredient().test(this.inventory.getStackInSlot(slot))) continue;
                slotsToShrink.put(slot, input.count());
                continue block0;
            }
        }
        return slotsToShrink;
    }

    private void recipeMultiplierByEnergy(double energyCostExact) {
        if (this.recipeMultiplier == 0) {
            return;
        }
        if (energyCostExact * (double)this.recipeMultiplier / (double)this.processTime <= (double)this.energy.getEnergyStored()) {
            return;
        }
        --this.recipeMultiplier;
        this.recipeMultiplierByEnergy(energyCostExact);
    }

    private void recipeMultiplierByOutput(int maxOutputSpace, int resultCount) {
        if (this.recipeMultiplier == 0) {
            return;
        }
        int outputCount = resultCount * this.recipeMultiplier;
        if (outputCount <= maxOutputSpace) {
            return;
        }
        --this.recipeMultiplier;
        this.recipeMultiplierByOutput(maxOutputSpace, resultCount);
    }

    private void stopWork() {
        this.changeActivityState(false);
        this.progress = 0;
        this.recipeCache = null;
    }

    private double calculateEnergyCost(ProcessorRecipe recipe) {
        int baseCost = recipe.getEnergyCost();
        return (double)baseCost * this.calculateMultiplier(upgrades -> this.getProcessorType().getEnergyCostMultiplier(upgrades));
    }

    private double calculateProcessTime(ProcessorRecipe recipe) {
        int baseTime = recipe.getProcessTime();
        return (double)baseTime * this.calculateMultiplier(upgrades -> this.getProcessorType().getProcessTimeMultiplier(upgrades));
    }

    private void autoExtract() {
        assert (this.f_58857_ != null);
        if (this.inventory.getStackInOutput().m_41619_()) {
            return;
        }
        this.sideConfig.forEachOutput(direction -> {
            BlockEntity extractEntity = this.f_58857_.m_7702_(this.f_58858_.m_5484_(direction, 1));
            if (extractEntity == null) {
                return;
            }
            this.updateAutoExtractCache((Direction)direction, extractEntity);
        });
        for (Map.Entry<Direction, LazyOptional<IItemHandler>> target : this.autoExtractCache.entrySet()) {
            if (target.getValue() == null) continue;
            AtomicBoolean outputEmpty = new AtomicBoolean(false);
            target.getValue().ifPresent(targetInv -> {
                ItemStack stack = this.inventory.getStackInOutput();
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)stack, (boolean)false);
                if (remainder.m_41619_()) {
                    this.inventory.setStackInOutput(ItemStack.f_41583_);
                    outputEmpty.set(true);
                } else if (remainder.m_41613_() < stack.m_41613_()) {
                    this.inventory.getStackInOutput().m_41764_(remainder.m_41613_());
                }
            });
            if (!outputEmpty.get()) continue;
            return;
        }
    }

    private void updateAutoExtractCache(Direction direction, BlockEntity provider) {
        this.autoExtractCache.computeIfAbsent(direction, d -> {
            LazyOptional target = provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.m_122424_());
            this.autoExtractCache.put((Direction)d, (LazyOptional<IItemHandler>)target);
            target.addListener(self -> this.autoExtractCache.put((Direction)d, (LazyOptional<IItemHandler>)null));
            return target;
        });
    }

    @Nullable
    private ProcessorRecipe detectRecipeFromInventory() {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        return GameUtil.getRecipeManager(this.f_58857_).m_44015_((RecipeType)this.getProcessorType(), this.inventory.toVanilla(), this.f_58857_).orElse(null);
    }

    @Nullable
    private ProcessorRecipe getRecipe() {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        if (this.recipeCache != null && this.recipeCache.m_5818_(this.inventory.toVanilla(), this.f_58857_)) {
            return this.recipeCache;
        }
        ProcessorRecipe recipe = this.detectRecipeFromInventory();
        if (recipe == null) {
            this.stopWork();
            return null;
        }
        this.recipeCache = recipe;
        return recipe;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    void setEnergyCost(int energyCost) {
        this.energyCost = energyCost;
    }

    public int getRecipeEnergy() {
        return this.recipeEnergy;
    }

    void setRecipeEnergy(int recipeEnergy) {
        this.recipeEnergy = recipeEnergy;
    }

    public ProcessorType getProcessorType() {
        return ((ProcessorBlock)this.m_58900_().m_60734_()).getProcessorType();
    }

    public int getProgress() {
        return this.progress;
    }

    void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    void setProcessTime(int processTime) {
        this.processTime = processTime;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    void setRecipeTime(int recipeTime) {
        this.recipeTime = recipeTime;
    }

    public boolean isAutoExtracting() {
        return this.autoExtract;
    }

    public void setAutoExtract(boolean autoExtract) {
        this.autoExtract = autoExtract;
    }
}

