/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.network.sync.IDataHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHandler
implements IEnergyStorage,
INBTSerializable<CompoundTag>,
IDataHandler {
    private final ProcessorEntity entity;
    protected int energy;
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private boolean changed;

    EnergyHandler(ProcessorEntity entity) {
        int baseEnergyBuffer;
        this.entity = entity;
        this.capacity = baseEnergyBuffer = entity.getProcessorType().getBaseEnergyBuffer();
        this.maxReceive = baseEnergyBuffer;
        this.maxExtract = baseEnergyBuffer;
        this.energy = 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.onChange();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.onChange();
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.energy);
        buffer.writeInt(this.capacity);
        this.changed = false;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.energy = buffer.readInt();
        this.capacity = buffer.readInt();
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("capacity", this.capacity);
        tag.m_128405_("energy", this.energy);
        tag.m_128405_("max_receive", this.maxReceive);
        tag.m_128405_("max_extract", this.maxExtract);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.capacity = tag.m_128451_("capacity");
        this.energy = tag.m_128451_("energy");
        this.maxReceive = tag.m_128451_("max_receive");
        this.maxExtract = tag.m_128451_("max_extract");
        this.onChange();
    }

    private void onChange() {
        this.entity.m_6596_();
        this.changed = true;
    }

    public void setEnergy(int energy) {
        this.energy = Math.min(energy, this.capacity);
        this.onChange();
    }

    void setCapacity(int capacity) {
        this.capacity = capacity;
        this.energy = Math.min(this.energy, capacity);
        this.maxReceive = capacity;
        this.maxExtract = capacity;
        this.onChange();
    }
}

