/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.kubejs;

import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.recipe.IngredientWithCount;
import com.almostreliable.lazierae2.recipe.builder.FinishedProcessorRecipe;
import com.almostreliable.lazierae2.recipe.builder.ProcessorRecipeBuilder;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ProcessorRecipeJS
extends RecipeJS {
    private final ProcessorType processorType;

    ProcessorRecipeJS(ProcessorType processorType) {
        this.processorType = processorType;
    }

    public void create(ListJS listJS) {
        if (listJS.size() < 2) {
            throw new IllegalArgumentException("Missing input or output for recipe type " + this.processorType.getId());
        }
        ItemStackJS output = ItemStackJS.of((Object)listJS.get(0));
        this.outputItems.add(output);
        if (this.processorType.getInputSlots() == 1) {
            this.inputItems.add(IngredientJS.of((Object)listJS.get(1)));
        } else {
            for (Object o : ListJS.orSelf((Object)listJS.get(1))) {
                this.inputItems.add(IngredientJS.of(o));
            }
        }
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("output")));
        this.inputItems.addAll(this.parseIngredientItemList(this.json.get("input")));
    }

    public void serialize() {
        if (this.serializeOutputs || this.serializeInputs) {
            ProcessorRecipeBuilder builder = this.getBuilder(((ItemStackJS)this.outputItems.get(0)).getItemStack());
            builder.processingTime(GsonHelper.m_13824_((JsonObject)this.json, (String)"process_time", (int)this.processorType.getBaseProcessTime()));
            builder.energyCost(GsonHelper.m_13824_((JsonObject)this.json, (String)"energy_cost", (int)this.processorType.getBaseEnergyCost()));
            this.inputItems.stream().map(ingredientJS -> {
                Ingredient ingredient = ingredientJS.createVanillaIngredient();
                int count = ingredientJS.getCount();
                return new IngredientWithCount(ingredient, count);
            }).forEach(xva$0 -> builder.input((IngredientWithCount)xva$0));
            ProcessorRecipe recipe = builder.build(this.getOrCreateId());
            FinishedProcessorRecipe finishedRecipe = new FinishedProcessorRecipe(recipe);
            JsonObject newRecipe = new JsonObject();
            finishedRecipe.m_7917_(newRecipe);
            this.json = newRecipe;
        }
    }

    public ProcessorRecipeJS processingTime(int processingTime) {
        this.json.addProperty("process_time", (Number)processingTime);
        this.save();
        return this;
    }

    public ProcessorRecipeJS energyCost(int energyCost) {
        this.json.addProperty("energy_cost", (Number)energyCost);
        this.save();
        return this;
    }

    private ProcessorRecipeBuilder getBuilder(ItemStack itemStack) {
        return switch (this.processorType) {
            default -> throw new IncompatibleClassChangeError();
            case ProcessorType.AGGREGATOR -> ProcessorRecipeBuilder.aggregator((ItemLike)itemStack.m_41720_(), itemStack.m_41613_());
            case ProcessorType.ETCHER -> ProcessorRecipeBuilder.etcher((ItemLike)itemStack.m_41720_(), itemStack.m_41613_());
            case ProcessorType.GRINDER -> ProcessorRecipeBuilder.grinder((ItemLike)itemStack.m_41720_(), itemStack.m_41613_());
            case ProcessorType.INFUSER -> ProcessorRecipeBuilder.infuser((ItemLike)itemStack.m_41720_(), itemStack.m_41613_());
        };
    }
}

