/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.jei;

import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorMenu;
import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.gui.ProcessorScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ProcessorGuiHandler
implements IGuiContainerHandler<ProcessorScreen> {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final RecipeType<?>[] recipeTypes;

    ProcessorGuiHandler(int x, int y, int width, int height, RecipeType<?> ... recipeTypes) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.recipeTypes = recipeTypes;
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(ProcessorScreen screen, double mX, double mY) {
        return Collections.singleton(this.createClickArea(screen, this.x, this.y, this.width, this.height, this.recipeTypes));
    }

    @OnlyIn(value=Dist.CLIENT)
    private IGuiClickableArea createClickArea(ProcessorScreen screen, int x, int y, int width, int height, final RecipeType<?> ... recipeTypes) {
        final Rect2i clickableArea = new Rect2i(x, y, width, height);
        final ProcessorType type = ((ProcessorEntity)((ProcessorMenu)screen.m_6262_()).entity).getProcessorType();
        return new IGuiClickableArea(){

            public Rect2i getArea() {
                return clickableArea;
            }

            public boolean isTooltipEnabled() {
                return false;
            }

            public void onClick(IFocusFactory focusFactory, IRecipesGui recipesGui) {
                ArrayList<RecipeType> list = new ArrayList<RecipeType>();
                for (RecipeType recipeType : recipeTypes) {
                    if (!recipeType.getUid().m_135815_().equals(type.getId())) continue;
                    list.add(recipeType);
                }
                recipesGui.showTypes(list);
            }
        };
    }
}

