/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.jei;

import appeng.api.ids.AEItemIds;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterCategory;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterDisplay;
import com.almostreliable.lazierae2.compat.jei.ProcessorGuiHandler;
import com.almostreliable.lazierae2.compat.jei.ProcessorRecipeInfo;
import com.almostreliable.lazierae2.compat.jei.RequesterGhostHandler;
import com.almostreliable.lazierae2.compat.jei.category.AggregatorCategory;
import com.almostreliable.lazierae2.compat.jei.category.EtcherCategory;
import com.almostreliable.lazierae2.compat.jei.category.GrinderCategory;
import com.almostreliable.lazierae2.compat.jei.category.InfuserCategory;
import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.core.Config;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.gui.ProcessorScreen;
import com.almostreliable.lazierae2.gui.RequesterScreen;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.almostreliable.lazierae2.recipe.type.SingleInputRecipe;
import com.almostreliable.lazierae2.recipe.type.TripleInputRecipe;
import com.almostreliable.lazierae2.util.GameUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

@JeiPlugin
public class Plugin
implements IModPlugin {
    private static <T extends ProcessorRecipe> List<T> validateRecipes(List<ProcessorRecipe> recipes, Class<T> clazz) {
        return recipes.stream().filter(clazz::isInstance).map(clazz::cast).toList();
    }

    private void registerInfoPages(IRecipeRegistration r) {
        if (((Boolean)Config.COMMON.pressDescription.get()).equals(Boolean.TRUE)) {
            r.addIngredientInfo((Object)new ItemStack((ItemLike)Setup.Items.UNIVERSAL_PRESS.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtil.translate(TypeEnums.TRANSLATE_TYPE.INFO, "universal_press", new ChatFormatting[0])});
        }
        if (((Boolean)Config.COMMON.singularityDescription.get()).equals(Boolean.TRUE)) {
            r.addIngredientInfo((Object)AEItems.SINGULARITY.stack(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtil.translate(TypeEnums.TRANSLATE_TYPE.INFO, AEItemIds.SINGULARITY.m_135815_(), new ChatFormatting[0])});
        }
    }

    public ResourceLocation getPluginUid() {
        return TextUtil.getRL("main");
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper guiHelper = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new AggregatorCategory(guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new EtcherCategory(guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new GrinderCategory(guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new InfuserCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        RecipeManager rm = GameUtil.getRecipeManager(null);
        r.addRecipes(AggregatorCategory.TYPE, Plugin.validateRecipes(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ProcessorType.AGGREGATOR), TripleInputRecipe.class));
        r.addRecipes(EtcherCategory.TYPE, Plugin.validateRecipes(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ProcessorType.ETCHER), TripleInputRecipe.class));
        r.addRecipes(GrinderCategory.TYPE, Plugin.validateRecipes(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ProcessorType.GRINDER), SingleInputRecipe.class));
        r.addRecipes(InfuserCategory.TYPE, Plugin.validateRecipes(rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ProcessorType.INFUSER), TripleInputRecipe.class));
        ArrayList<ThrowingInWaterDisplay> inWaterRecipes = new ArrayList<ThrowingInWaterDisplay>();
        if (AEConfig.instance().isInWorldCrystalGrowthEnabled()) {
            inWaterRecipes.add(new ThrowingInWaterDisplay(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Setup.Items.RESONATING_SEED.get()})), new ItemStack((ItemLike)Setup.Items.RESONATING_CRYSTAL.get()), true));
        }
        if (((Boolean)Config.COMMON.inWorldResonating.get()).equals(Boolean.TRUE)) {
            inWaterRecipes.add(new ThrowingInWaterDisplay(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.SKY_DUST}), Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.ENDER_DUST})), new ItemStack((ItemLike)Setup.Items.RESONATING_DUST.get(), 2), false));
        }
        r.addRecipes(new RecipeType(ThrowingInWaterCategory.ID, ThrowingInWaterDisplay.class), inWaterRecipes);
        this.registerInfoPages(r);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration r) {
        r.addRecipeTransferHandler(new ProcessorRecipeInfo<TripleInputRecipe>(AggregatorCategory.TYPE, 2, 3, 5, 36));
        r.addRecipeTransferHandler(new ProcessorRecipeInfo<TripleInputRecipe>(EtcherCategory.TYPE, 2, 3, 5, 36));
        r.addRecipeTransferHandler(new ProcessorRecipeInfo<SingleInputRecipe>(GrinderCategory.TYPE, 2, 1, 3, 36));
        r.addRecipeTransferHandler(new ProcessorRecipeInfo<TripleInputRecipe>(InfuserCategory.TYPE, 2, 3, 5, 36));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)Setup.Blocks.AGGREGATOR.get()), new RecipeType[]{AggregatorCategory.TYPE});
        r.addRecipeCatalyst(new ItemStack((ItemLike)Setup.Blocks.ETCHER.get()), new RecipeType[]{EtcherCategory.TYPE});
        r.addRecipeCatalyst(new ItemStack((ItemLike)Setup.Blocks.GRINDER.get()), new RecipeType[]{GrinderCategory.TYPE});
        r.addRecipeCatalyst(new ItemStack((ItemLike)Setup.Blocks.INFUSER.get()), new RecipeType[]{InfuserCategory.TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration r) {
        r.addGuiContainerHandler(ProcessorScreen.class, (IGuiContainerHandler)new ProcessorGuiHandler(78, 24, 20, 27, AggregatorCategory.TYPE, EtcherCategory.TYPE, GrinderCategory.TYPE, InfuserCategory.TYPE));
        r.addGhostIngredientHandler(RequesterScreen.class, (IGhostIngredientHandler)new RequesterGhostHandler());
    }
}

