/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.DiskDriveBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import edivad.extrastorage.blockentity.AdvancedImporterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedImporterNetworkNode
extends NetworkNode
implements IComparable,
IWhitelistBlacklist,
IType {
    public static final ResourceLocation ID = new ResourceLocation("extrastorage", "advanced_importer");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private final BaseItemHandler itemFilters = new BaseItemHandler(18).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(18).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int currentSlot;

    public AdvancedImporterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage());
    }

    public void update() {
        FluidStack toDrain;
        FluidStack stack;
        IFluidHandler handler;
        super.update();
        if (!this.canUpdate() || !this.level.m_46749_(this.pos)) {
            return;
        }
        if (this.type == 0) {
            BlockEntity facing = this.getFacingBlockEntity();
            IItemHandler handler2 = LevelUtils.getItemHandler((BlockEntity)facing, (Direction)this.getDirection().m_122424_());
            if (facing instanceof DiskDriveBlockEntity || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                while (this.currentSlot + 1 < handler2.getSlots() && handler2.getStackInSlot(this.currentSlot).m_41619_()) {
                    ++this.currentSlot;
                }
                ItemStack stack2 = handler2.getStackInSlot(this.currentSlot);
                if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)stack2)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    ItemStack result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), true);
                    if (!result.m_41619_() && this.network.insertItem(result, result.m_41613_(), Action.SIMULATE).m_41619_()) {
                        result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), false);
                        this.network.insertItemTracked(result, result.m_41613_());
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && this.ticks % this.upgrades.getSpeed() == 0 && (handler = LevelUtils.getFluidHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_())) != null && !(stack = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)stack) && this.network.insertFluid(stack, stack.getAmount(), Action.SIMULATE).isEmpty() && !(toDrain = handler.drain(1000 * this.upgrades.getStackInteractCount(), IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            FluidStack remainder = this.network.insertFluidTracked(toDrain, toDrain.getAmount());
            if (!remainder.isEmpty()) {
                toDrain.shrink(remainder.getAmount());
            }
            handler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.upgrades;
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)AdvancedImporterBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }
}

