/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageWrapperStorageDisk;
import edivad.extrastorage.blockentity.AdvancedFluidStorageBlockEntity;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class AdvancedFluidStorageNetworkNode
extends FluidStorageNetworkNode {
    public static final ResourceLocation BLOCK_FLUID_16384K_ID = new ResourceLocation("extrastorage", "block_16384k_fluid");
    public static final ResourceLocation BLOCK_FLUID_65536K_ID = new ResourceLocation("extrastorage", "block_65536k_fluid");
    public static final ResourceLocation BLOCK_FLUID_262144K_ID = new ResourceLocation("extrastorage", "block_262144k_fluid");
    public static final ResourceLocation BLOCK_FLUID_1048576K_ID = new ResourceLocation("extrastorage", "block_1048576k_fluid");
    private final FluidStorageType type;
    private IStorageDisk<FluidStack> storage;

    public AdvancedFluidStorageNetworkNode(Level level, BlockPos pos, FluidStorageType type) {
        super(level, pos, null);
        this.type = type;
    }

    public int getEnergyUsage() {
        return 10 + this.type.ordinal() * 2;
    }

    public ResourceLocation getId() {
        return switch (this.type) {
            case FluidStorageType.TIER_5 -> BLOCK_FLUID_16384K_ID;
            case FluidStorageType.TIER_6 -> BLOCK_FLUID_65536K_ID;
            case FluidStorageType.TIER_7 -> BLOCK_FLUID_262144K_ID;
            case FluidStorageType.TIER_8 -> BLOCK_FLUID_1048576K_ID;
            default -> null;
        };
    }

    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<FluidStack>)this.storage);
    }

    public void loadStorage(@Nullable Player owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerLevel)this.level).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultFluidDisk((ServerLevel)this.level, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerLevel)this.level).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerLevel)this.level).markForSaving();
        }
        this.storage = new FluidStorageWrapperStorageDisk((FluidStorageNetworkNode)this, disk);
    }

    public IStorageDisk<FluidStack> getStorage() {
        return this.storage;
    }

    public Component getTitle() {
        return new TranslatableComponent("block.extrastorage.block_" + this.type.getName() + "_fluid");
    }

    public long getStored() {
        return (Long)AdvancedFluidStorageBlockEntity.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

