/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.ToDoubleBiFunction;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

@OnlyIn(value=Dist.CLIENT)
public class BOWindow
extends View {
    protected static final int DEFAULT_WIDTH = 420;
    protected static final int DEFAULT_HEIGHT = 240;
    protected BOScreen screen;
    protected boolean windowPausesGame = true;
    protected boolean lightbox = true;
    protected WindowRenderType windowRenderType = WindowRenderType.OVERSIZED_VANILLA;
    protected ResourceLocation xmlResourceLocation;

    public BOWindow(ResourceLocation resource) {
        this();
        this.xmlResourceLocation = resource;
        Loader.createFromXMLFile(resource, this);
    }

    public BOWindow() {
        this(420, 240);
    }

    public BOWindow(int w, int h) {
        this.width = w;
        this.height = h;
        this.screen = new BOScreen(this);
        this.window = this;
    }

    public void loadParams(PaneParams params) {
        params.getResource("inherit", r -> Loader.createFromXMLFile(r, this));
        params.applyShorthand("size", Parsers.INT, 2, a -> {
            this.width = (Integer)a.get(0);
            this.height = (Integer)a.get(1);
        });
        this.lightbox = params.getBoolean("lightbox", this.lightbox);
        this.windowPausesGame = params.getBoolean("pause", this.windowPausesGame);
        this.windowRenderType = params.getEnum("type", WindowRenderType.class, this.windowRenderType);
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        this.updateDebugging();
        super.drawSelf(ms, mx, my);
    }

    private boolean isKeyDown(int keyCode) {
        return InputConstants.m_84830_((long)this.mc.m_91268_().m_85439_(), (int)keyCode);
    }

    private void updateDebugging() {
        debugging = this.isKeyDown(340) && this.isKeyDown(342) && (this.isKeyDown(341) || this.isKeyDown(343));
    }

    public boolean hasLightbox() {
        return this.lightbox;
    }

    public boolean doesWindowPauseGame() {
        return this.windowPausesGame;
    }

    public WindowRenderType getRenderType() {
        return this.windowRenderType;
    }

    public ResourceLocation getXmlResourceLocation() {
        return this.xmlResourceLocation;
    }

    public void open() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.mc.m_18707_(() -> this.mc.m_91152_((Screen)this.screen)));
    }

    public BOScreen getScreen() {
        return this.screen;
    }

    public boolean onMouseReleased(double mx, double my) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        if (BOWindow.getFocus() != null && BOWindow.getFocus().onKeyTyped(ch, key)) {
            return true;
        }
        return this.onUnhandledKeyTyped(ch, key);
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public void close() {
        this.screen.m_7861_();
        this.mc.f_91074_.m_6915_();
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public static enum WindowRenderType {
        VANILLA((mcWindow, window) -> Math.max(mcWindow.m_85449_(), 1.0)),
        FULLSCREEN((mcWindow, window) -> {
            double widthScale = (double)mcWindow.m_85443_() / (double)window.getWidth();
            double heightScale = (double)mcWindow.m_85444_() / (double)window.getHeight();
            return Math.min(widthScale, heightScale);
        }),
        FULLSCREEN_VANILLA((mcWindow, window) -> {
            double widthScale = Math.max((double)mcWindow.m_85443_(), 320.0) / (double)window.getWidth();
            double heightScale = Math.max((double)mcWindow.m_85444_(), 240.0) / (double)window.getHeight();
            return Math.min(widthScale, heightScale);
        }),
        FIXED((mcWindow, window) -> 1.0),
        FIXED_VANILLA((mcWindow, window) -> Math.min(FULLSCREEN_VANILLA.calcRenderScale((Window)mcWindow, (BOWindow)window), 1.0)),
        OVERSIZED((mcWindow, window) -> {
            double fs = FULLSCREEN.calcRenderScale((Window)mcWindow, (BOWindow)window);
            int userScale = ((BOWindow)window).mc.f_91066_.f_92072_;
            return fs < 1.0 ? fs : Math.min(Math.floor(fs), userScale == 0 ? Double.MAX_VALUE : (double)userScale);
        }),
        OVERSIZED_VANILLA((mcWindow, window) -> {
            double fs_vanilla = FULLSCREEN_VANILLA.calcRenderScale((Window)mcWindow, (BOWindow)window);
            int userScale = ((BOWindow)window).mc.f_91066_.f_92072_;
            return fs_vanilla < 1.0 ? fs_vanilla : Math.min(Math.floor(fs_vanilla), userScale == 0 ? Double.MAX_VALUE : (double)userScale);
        });

        private final ToDoubleBiFunction<Window, BOWindow> renderScaleCalculator;

        private WindowRenderType(ToDoubleBiFunction<Window, BOWindow> renderScaleCalculator) {
            this.renderScaleCalculator = renderScaleCalculator;
        }

        public double calcRenderScale(Window mcWindow, BOWindow window) {
            return this.renderScaleCalculator.applyAsDouble(mcWindow, window);
        }
    }
}

