/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class InfuseHelper {
    @Nonnull
    public static Optional<IInfusionHandler> handler(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.INFUSION_HANDLER_CAPABILITY != null && provider.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, direction).isPresent()) {
            return Optional.of((IInfusionHandler)provider.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, direction).orElseThrow(() -> new IllegalArgumentException("IInfusionHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof IInfusionHandler.ISidedInfusionHandler && ((IInfusionHandler.ISidedInfusionHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((IInfusionHandler)provider);
        }
        if (!(provider instanceof IInfusionHandler.ISidedInfusionHandler) && provider instanceof IInfusionHandler && ((IInfusionHandler)provider).getTanks() >= 1) {
            return Optional.of((IInfusionHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static InfusionStack insert(IInfusionHandler handler, InfusionStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            return (InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (InfusionStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static InfusionStack extract(IInfusionHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            return (InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).extractChemical(amount, direction, action);
        }
        return (InfusionStack)handler.extractChemical(amount, action);
    }

    public static List<InfuseType> chemicalInTank(@Nonnull IInfusionHandler handler, @Nullable Direction direction) {
        ArrayList<InfuseType> infuses = new ArrayList<InfuseType>();
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            for (int i = 0; i < ((IInfusionHandler.ISidedInfusionHandler)handler).getTanks(direction); ++i) {
                InfuseType infuse = (InfuseType)((InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).getChemicalInTank(i, direction)).getType();
                if (infuse.isEmptyType()) continue;
                infuses.add(infuse);
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                InfuseType infuse = (InfuseType)((InfusionStack)handler.getChemicalInTank(i)).getType();
                if (infuse.isEmptyType()) continue;
                infuses.add(infuse);
            }
        }
        return infuses;
    }

    public static List<InfuseType> chemicalInTank(@Nonnull IInfusionHandler handler) {
        return InfuseHelper.chemicalInTank(handler, null);
    }

    public static long amountInTank(@Nonnull IInfusionHandler handler, @Nullable Direction direction, @Nullable Predicate<InfusionStack> filter) {
        long count = 0L;
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            for (int i = 0; i < ((IInfusionHandler.ISidedInfusionHandler)handler).getTanks(direction); ++i) {
                InfusionStack stack = (InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                InfusionStack stack = (InfusionStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long amountInTank(@Nonnull IInfusionHandler handler, @Nullable Direction direction, @Nullable InfuseType filter) {
        return InfuseHelper.amountInTank(handler, direction, (InfusionStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long amountInTank(@Nonnull IInfusionHandler handler, @Nullable Direction direction, @Nullable InfusionStack filter) {
        return InfuseHelper.amountInTank(handler, direction, (InfusionStack stack) -> filter == null || stack.isTypeEqual((ChemicalStack)filter));
    }

    public static long amountInTank(@Nonnull IInfusionHandler handler, @Nullable Direction direction) {
        return InfuseHelper.amountInTank(handler, direction, (Predicate<InfusionStack>)null);
    }

    public static long amountInTank(@Nonnull IInfusionHandler handler) {
        return InfuseHelper.amountInTank(handler, null);
    }
}

