/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.registry.AbstractRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.EntityRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.block.BlockRegistryHelper;

public class RegistryManager {
    private final Map<ResourceKey<?>, AbstractRegistryHelper<?>> helpers = new HashMap();
    private final String modId;
    private AbstractConfigValidator configValidator = null;

    private RegistryManager(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public <T extends IForgeRegistryEntry<T>> boolean hasHelper(ResourceKey<Registry<T>> registryResourceKey) {
        return this.helpers.containsKey(registryResourceKey);
    }

    private <T extends IForgeRegistryEntry<T>> void addHelper(AbstractRegistryHelper<T> registryHelper) {
        this.helpers.put(registryHelper.getRegistryKey(), registryHelper);
    }

    public <T extends IForgeRegistryEntry<T>> AbstractRegistryHelper<?> getHelper(ResourceKey<Registry<T>> registryResourceKey) {
        if (!this.hasHelper(registryResourceKey)) {
            throw new NullPointerException("Registry Manager for '" + this.getModId() + "' has no Helper for registry: " + registryResourceKey.getRegistryName());
        }
        return this.helpers.get(registryResourceKey);
    }

    public ItemRegistryHelper getItemHelper() {
        return (ItemRegistryHelper)this.getHelper(ForgeRegistries.Keys.ITEMS);
    }

    public BlockRegistryHelper getBlockHelper() {
        return (BlockRegistryHelper)this.getHelper(ForgeRegistries.Keys.BLOCKS);
    }

    public EntityRegistryHelper getEntityHelper() {
        return (EntityRegistryHelper)this.getHelper(ForgeRegistries.Keys.ENTITY_TYPES);
    }

    public void register(IEventBus eventBus) {
        this.helpers.values().forEach(abstractRegistryHelper -> abstractRegistryHelper.register(eventBus));
    }

    public void registerConfigValidator(AbstractConfigValidator configValidator) {
        this.configValidator = configValidator;
    }

    @Nullable
    public AbstractConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public static class Builder {
        private final RegistryManager registryManager;

        public Builder(String modId) {
            this.registryManager = new RegistryManager(modId);
        }

        public Builder addDefaultHelpers() {
            return this.addHelpers(new ItemRegistryHelper(), new BlockRegistryHelper());
        }

        public Builder addHelpers(AbstractRegistryHelper<?> ... registryHelpers) {
            for (AbstractRegistryHelper<?> registryHelper : registryHelpers) {
                registryHelper.setRegistryManager(this.registryManager);
                registryHelper.createDeferredRegister();
                this.registryManager.addHelper(registryHelper);
            }
            return this;
        }

        public RegistryManager build() {
            ValhelsiaCore.REGISTRY_MANAGERS.add(this.registryManager);
            return this.registryManager;
        }
    }
}

