/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.LocationData;
import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityData
extends LocationData {
    public EntityData() {
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            this.map.put(((ResourceKey)entry.getKey()).m_135782_(), new ArrayList());
        }
    }

    public EntityData(Map<ResourceLocation, List<WorldPos>> map) {
        this.map = map;
    }

    public void createLists(List<ServerLevel> worlds) {
        ArrayList entities = new ArrayList();
        worlds.forEach(x -> x.m_142646_().m_142273_().forEach(entities::add));
        for (Entity entity : entities) {
            ((List)this.map.get(entity.m_6095_().getRegistryName())).add(WorldPos.getPosFromEntity(entity));
        }
        this.total = entities.size();
    }

    public void reply(ResourceLocation res, CommandSourceStack source) {
        if (res == null) {
            this.map.entrySet().stream().filter(x -> ((List)x.getValue()).size() != 0).sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).forEach(e -> CommandUtils.sendFindEMessage(source, (ResourceLocation)e.getKey(), ((List)e.getValue()).size()));
            CommandUtils.sendNormalMessage(source, this.total + " Entities", ChatFormatting.DARK_AQUA);
        } else {
            this.sendEntityChunkMapCommand(source, res);
        }
    }

    private void sendEntityChunkMapCommand(CommandSourceStack source, ResourceLocation res) {
        this.fillChunkMaps(res.toString());
        CommandUtils.sendNormalMessage(source, res.toString(), ChatFormatting.DARK_BLUE);
        this.chunkMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(List::size))).forEach(k -> CommandUtils.sendChunkEntityMessage(source, ((List)k.getValue()).size(), ((WorldPos)this.tpPos.get(k.getKey())).pos, ((WorldPos)this.tpPos.get(k.getKey())).type, true));
    }
}

