/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CrashUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class ClearItemTask
extends TimerTask {
    public static ClearItemTask INSTANCE;
    int maxItems;
    List<Integer> list = new ArrayList<Integer>();
    Timer timer;
    public int lastCount;

    public static void start() {
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            INSTANCE = new ClearItemTask();
            INSTANCE.loadConfigsAndStart();
        }
    }

    public static void restart() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
        }
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            INSTANCE = new ClearItemTask();
            INSTANCE.loadConfigsAndStart();
        }
    }

    private void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.list.clear();
        this.maxItems = 5000;
    }

    public void loadConfigsAndStart() {
        if (ClearItemTask.INSTANCE.timer != null) {
            ClearItemTask.INSTANCE.timer.cancel();
        }
        ClearItemTask.INSTANCE.timer = new Timer("CU Clear Item Task", true);
        this.maxItems = CrashUtils.SERVER_CONFIG.getMaximum();
        this.list = CrashUtils.SERVER_CONFIG.getWarnings();
        this.list.sort(Comparator.comparing(Integer::intValue));
        int time = CrashUtils.SERVER_CONFIG.getTimer() * 60 * 1000;
        if (time == 0) {
            time = 10000;
        }
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            this.timer.scheduleAtFixedRate((TimerTask)this, time, (long)time);
        }
    }

    @Override
    public void run() {
        CrashUtils.runNextTick(this::runClear);
    }

    private void runClear(final ServerLevel world) {
        ArrayList entityList = new ArrayList();
        world.m_142646_().m_142273_().forEach(x -> {
            if (x.m_6095_().equals(EntityType.f_20461_)) {
                entityList.add(x);
            }
        });
        this.lastCount = entityList.size();
        if (this.lastCount < this.maxItems) {
            return;
        }
        String text = CrashUtils.SERVER_CONFIG.getWarningText();
        int last = this.list.get(this.list.size() - 1);
        for (Integer integer : this.list) {
            if (integer.equals(last)) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ArrayList entityList = new ArrayList();
                        world.m_142646_().m_142273_().forEach(x -> {
                            if (x.m_6095_().equals(EntityType.f_20461_)) {
                                entityList.add(x);
                            }
                        });
                        int size = ClearItemTask.this.list.size();
                        if (size > ClearItemTask.this.maxItems) {
                            entityList.forEach(entity -> entity.m_142687_(Entity.RemovalReason.DISCARDED));
                            world.m_142572_().m_6846_().m_11264_((Component)new TextComponent(size + " Items cleared"), ChatType.SYSTEM, Util.f_137441_);
                        } else {
                            world.m_142572_().m_6846_().m_11264_((Component)new TextComponent("Item Clear prevented. Only " + size + " items on the ground"), ChatType.SYSTEM, Util.f_137441_);
                        }
                    }
                }, (long)integer.intValue() * 1000L);
            }
            String intText = text.replaceFirst("%", integer.toString());
            MutableComponent message = new TextComponent("[=== ").m_7220_((Component)new TextComponent(intText).m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent(" ===]"));
            new Timer().schedule(new TimerTask((Component)message){
                final /* synthetic */ Component val$message;
                {
                    this.val$message = component;
                }

                @Override
                public void run() {
                    world.m_142572_().m_6846_().m_11264_(this.val$message, ChatType.SYSTEM, Util.f_137441_);
                }
            }, (long)(last - integer) * 1000L);
        }
        if (!CrashUtils.SERVER_CONFIG.getTitle()) {
            return;
        }
        try {
            if (world.m_142572_().m_6846_().m_11314_().size() == 0) {
                return;
            }
            world.m_142572_().m_129892_().m_82094_().execute("title @a title {\"text\":\"" + CrashUtils.SERVER_CONFIG.getTitleText() + "\",\"color\":\"dark_red\"}", (Object)world.m_142572_().m_129893_());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }
}

