/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.registry.minecraft;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestUpgradeType;
import tech.thatgravyboat.ironchests.common.items.DollyItem;
import tech.thatgravyboat.ironchests.common.items.KeyItem;
import tech.thatgravyboat.ironchests.common.items.LockItem;
import tech.thatgravyboat.ironchests.common.items.UpgradeItem;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestUpgradeTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.minecraft.forge.ItemRegistryImpl;

public class ItemRegistry {
    public static final Supplier<Item> BLANK_UPGRADE = ItemRegistry.register("blank_chest_upgrade", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> LOCK = ItemRegistry.register("lock", () -> new LockItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> KEY = ItemRegistry.register("key", () -> new KeyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> DIAMOND_DOLLY = ItemRegistry.register("diamond_dolly", () -> new DollyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1)));
    public static final Supplier<Item> IRON_DOLLY = ItemRegistry.register("iron_dolly", () -> new DollyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41503_(15)));

    public static void init() {
        ChestTypeRegistry.INSTANCE.getChests().forEach(ItemRegistry::registerChest);
        ChestUpgradeTypeRegistry.INSTANCE.getUpgrades().forEach(ItemRegistry::registerUpgrade);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Item> Supplier<T> register(String id, Supplier<T> item) {
        void var1_1;
        return ItemRegistryImpl.register(id, var1_1);
    }

    private static void registerChest(String id, ChestType type) {
        ItemRegistry.register(id, () -> new BlockItem((Block)type.registries().getBlock().get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    }

    private static void registerUpgrade(ChestUpgradeType type) {
        ItemRegistry.register(type.to().name() + "_chest_upgrade", () -> new UpgradeItem(type, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    }
}

