/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.blocks.LockState;
import tech.thatgravyboat.ironchests.common.utils.ModUtils;

public class KeyItem
extends Item {
    public KeyItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        ItemStack stack = context.m_43722_();
        if (state.m_60734_() instanceof GenericChestBlock && blockEntity instanceof GenericChestBlockEntity) {
            GenericChestBlockEntity chestBlockEntity = (GenericChestBlockEntity)blockEntity;
            if (chestBlockEntity.viewers() > 0) {
                return InteractionResult.PASS;
            }
            if (((LockState)((Object)state.m_61143_(GenericChestBlock.LOCK))).equals((Object)LockState.NO_LOCK)) {
                return InteractionResult.PASS;
            }
            if (stack.m_41782_() && stack.m_41784_().m_128441_("key") && chestBlockEntity.isRightKey(stack)) {
                level.m_7731_(pos, (BlockState)state.m_61124_(GenericChestBlock.LOCK, (Comparable)((Object)((LockState)((Object)state.m_61143_(GenericChestBlock.LOCK))).opposite())), 2);
                level.m_46717_(pos, state.m_60734_());
                return InteractionResult.SUCCESS;
            }
            if (!(stack.m_41782_() && stack.m_41784_().m_128441_("key") || !((LockState)((Object)state.m_61143_(GenericChestBlock.LOCK))).equals((Object)LockState.UNLOCKED))) {
                chestBlockEntity.setLockKey(stack);
                stack.m_41784_().m_128365_("chest", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                stack.m_41784_().m_128359_("chestType", Component.Serializer.m_130703_((Component)chestBlockEntity.m_5446_()));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(@NotNull ItemStack itemStack) {
        return this.hasKeyId(itemStack) || super.m_5812_(itemStack);
    }

    private boolean hasKeyId(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_("key");
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        ModUtils.getTag(stack).ifPresent(tag -> {
            if (tag.m_128441_("chest") && tag.m_128441_("chestType")) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("chest"));
                MutableComponent chestType = Component.Serializer.m_130701_((String)tag.m_128461_("chestType"));
                if (chestType != null) {
                    list.add((Component)new TranslatableComponent("item.key.chesttype").m_7220_((Component)chestType));
                }
                list.add((Component)new TranslatableComponent("item.key.chestpos", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
            }
        });
        super.m_7373_(stack, level, list, tooltipFlag);
    }
}

