/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.location;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountPart;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanPart;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientPartOpenPacket;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;
import org.cyclops.integratedterminals.part.PartTypes;

public class TerminalStorageLocationPart
implements ITerminalStorageLocation<PartPos> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integratedterminals", "part");
    }

    @Override
    public <T, M> void openContainerFromClient(CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData) {
        PartPos partPos = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientPartOpenPacket.send(partPos.getPos().getBlockPos(), partPos.getSide(), craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerFromServer(CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData, Level world, ServerPlayer player) {
        PartPos partPos = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientPartOpenPacket.openServer(world, partPos.getPos().getBlockPos(), partPos.getSide(), player, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerCraftingPlan(final CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData, final Level world, ServerPlayer player) {
        MenuProvider containerProvider = new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                PartPos location = (PartPos)craftingOptionGuiData.getLocationInstance();
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)PartPos.of((Level)world, (BlockPos)location.getPos().getBlockPos(), (Direction)location.getSide()));
                return new ContainerTerminalStorageCraftingPlanPart(id, playerInventory, Optional.of((PartTarget)data.getRight()), Optional.of((IPartContainer)data.getLeft()), (PartTypeTerminalStorage)((Object)data.getMiddle()), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> {
            packetBuffer.m_130070_(PartTypes.TERMINAL_STORAGE.getUniqueName().toString());
            craftingOptionGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    @Override
    public <T, M> void openContainerCraftingOptionAmount(final CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData, final Level world, ServerPlayer player) {
        MenuProvider containerProvider = new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                PartPos location = (PartPos)craftingOptionGuiData.getLocationInstance();
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)PartPos.of((Level)world, (BlockPos)location.getPos().getBlockPos(), (Direction)location.getSide()));
                return new ContainerTerminalStorageCraftingOptionAmountPart(id, playerInventory, Optional.of((PartTarget)data.getRight()), Optional.of((IPartContainer)data.getLeft()), (PartTypeTerminalStorage)((Object)data.getMiddle()), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> {
            packetBuffer.m_130070_(PartTypes.TERMINAL_STORAGE.getUniqueName().toString());
            craftingOptionGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    @Override
    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer, PartPos location) {
        PacketCodec.getAction(PartPos.class).encode((Object)location, packetBuffer);
    }

    @Override
    public PartPos readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        return (PartPos)PacketCodec.getAction(PartPos.class).decode(packetBuffer);
    }
}

