/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetAutoRefill;

public class TerminalButtonItemStackCraftingGridAutoRefill<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentItemStackCraftingCommon, ButtonImage> {
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private AutoRefillType active;

    public TerminalButtonItemStackCraftingGridAutoRefill(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "itemstack_grid_autorefill";
        this.clientTab = clientTab;
        this.reloadFromState();
        this.notifyServer((TerminalStorageTabIngredientComponentClient)clientTab);
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = AutoRefillType.values()[data.m_128451_("active")];
        } else {
            this.active = AutoRefillType.STORAGE;
        }
    }

    protected void notifyServer(TerminalStorageTabIngredientComponentClient<T, ?> clientTab) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetAutoRefill(clientTab.getName().toString(), this.active));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ButtonImage createButton(int x, int y) {
        return new ButtonImage(x, y, (Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.craftinggrid.autorefill"), b -> {}, new IImage[]{this.active == AutoRefillType.DISABLED ? Images.BUTTON_BACKGROUND_INACTIVE : Images.BUTTON_BACKGROUND_ACTIVE, this.active.getImage()});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, TerminalStorageTabIngredientComponentItemStackCraftingCommon commomTab, ButtonImage guiButton, int channel, int mouseButton) {
        this.active = mouseButton == 0 ? AutoRefillType.values()[(this.active.ordinal() + 1) % AutoRefillType.values().length] : AutoRefillType.DISABLED;
        CompoundTag data = new CompoundTag();
        data.m_128405_("active", this.active.ordinal());
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (Tag)data);
        this.notifyServer(clientTab);
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.craftinggrid.autorefill";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.craftinggrid.autorefill.info").m_130940_(ChatFormatting.GRAY));
        lines.add((Component)new TranslatableComponent(this.active.getLabel()));
    }

    public static enum AutoRefillType {
        DISABLED((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_DISABLED, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.disabled"),
        STORAGE((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_STORAGE, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.storage"),
        PLAYER((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_PLAYER, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.player"),
        STORAGE_PLAYER((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_STORAGEPLAYER, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.storage_player"),
        PLAYER_STORAGE((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_PLAYERSTORAGE, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.player_storage");

        @Nullable
        private final IImage image;
        private final String label;

        private AutoRefillType(IImage image, String label) {
            this.image = image;
            this.label = label;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

