/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.ensorcellation.enchantment.AnglerEnchantment;
import cofh.ensorcellation.enchantment.CavalierEnchantment;
import cofh.ensorcellation.enchantment.DamageEnderEnchantment;
import cofh.ensorcellation.enchantment.DamageIllagerEnchantment;
import cofh.ensorcellation.enchantment.DamageVillagerEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostAspectEnchantment;
import cofh.ensorcellation.enchantment.HunterEnchantment;
import cofh.ensorcellation.enchantment.MagicEdgeEnchantment;
import cofh.ensorcellation.enchantment.PilferingEnchantment;
import cofh.ensorcellation.enchantment.VitalityEnchantment;
import cofh.ensorcellation.enchantment.VorpalEnchantment;
import cofh.ensorcellation.enchantment.XpBoostEnchantment;
import cofh.ensorcellation.enchantment.override.FrostWalkerEnchantmentImp;
import cofh.ensorcellation.init.EnsorcEnchantments;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class CommonEvents {
    private CommonEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        int encMagicEdge;
        if (event.isCanceled()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity && (encMagicEdge = Utils.getHeldEnchantmentLevel((LivingEntity)((LivingEntity)attacker), (Enchantment)((Enchantment)EnsorcEnchantments.MAGIC_EDGE.get()))) > 0 && !source.m_19387_()) {
            source.m_19380_().m_19389_();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity living;
        int encMercy;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity && (encMercy = Utils.getHeldEnchantmentLevel((LivingEntity)(living = (LivingEntity)attacker), (Enchantment)((Enchantment)EnsorcEnchantments.CURSE_MERCY.get()))) > 0 && event.getAmount() > entity.m_21223_()) {
            event.setAmount(Math.max(0.0f, entity.m_21223_() - 1.0f));
        }
    }

    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity living;
        int encLeech;
        if (event.isCanceled()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity && (encLeech = Utils.getHeldEnchantmentLevel((LivingEntity)(living = (LivingEntity)attacker), (Enchantment)((Enchantment)EnsorcEnchantments.LEECH.get()))) > 0) {
            living.m_5634_((float)encLeech);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingDropsEvent(LivingDropsEvent event) {
        int encVorpal;
        ItemEntity drop;
        int emeraldDrop;
        int encDamageVillager;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player) || !event.isRecentlyHit()) {
            return;
        }
        Player player = (Player)attacker;
        int encHunter = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.HUNTER.get()));
        if (encHunter > 0 && entity instanceof Animal) {
            LootTable table = entity.f_19853_.m_142572_().m_129898_().m_79217_(entity.m_5743_());
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)entity.f_19853_).m_78977_(entity.f_19853_.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)source).m_78984_(LootContextParams.f_81458_, (Object)source.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)source.m_7640_());
            contextBuilder = contextBuilder.m_78972_(LootContextParams.f_81456_, (Object)player).m_78963_(player.m_36336_());
            for (int i = 0; i < encHunter; ++i) {
                if (player.m_21187_().nextInt(100) >= HunterEnchantment.chance) continue;
                for (ItemStack stack : table.m_79129_(contextBuilder.m_78975_(LootContextParamSets.f_81415_))) {
                    ItemEntity drop2 = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
                    event.getDrops().add(drop2);
                }
            }
        }
        if ((encDamageVillager = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.DAMAGE_VILLAGER.get()))) > 0 && DamageVillagerEnchantment.validTarget((Entity)entity) && (emeraldDrop = MathHelper.nextInt((int)0, (int)encDamageVillager)) > 0) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, emeraldDrop);
            drop = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
            event.getDrops().add(drop);
        }
        if ((encVorpal = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.VORPAL.get()))) > 0) {
            ItemStack itemSkull = ItemStack.f_41583_;
            if (entity.f_19853_.f_46441_.nextInt(100) < VorpalEnchantment.headBase + VorpalEnchantment.headLevel * encVorpal) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer target = (ServerPlayer)event.getEntity();
                    itemSkull = new ItemStack((ItemLike)Blocks.f_50316_);
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("SkullOwner", target.m_7755_().getString());
                    itemSkull.m_41751_(tag);
                } else if (entity instanceof Skeleton) {
                    itemSkull = new ItemStack((ItemLike)Blocks.f_50310_);
                } else if (entity instanceof WitherSkeleton) {
                    itemSkull = new ItemStack((ItemLike)Blocks.f_50312_);
                } else if (entity instanceof Zombie) {
                    itemSkull = new ItemStack((ItemLike)Blocks.f_50314_);
                } else if (entity instanceof Creeper) {
                    itemSkull = new ItemStack((ItemLike)Blocks.f_50318_);
                }
            }
            if (itemSkull.m_41619_()) {
                return;
            }
            drop = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemSkull);
            drop.m_32010_(10);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public static void handleLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        int encReach = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)((Enchantment)EnsorcEnchantments.REACH.get()));
        AttributeInstance reachAttr = entity.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttr != null) {
            reachAttr.m_22120_(Constants.UUID_ENCH_REACH_DISTANCE);
            if (encReach > 0) {
                reachAttr.m_22118_(new AttributeModifier(Constants.UUID_ENCH_REACH_DISTANCE, "reach", (double)encReach, AttributeModifier.Operation.ADDITION));
            }
        }
        int encVitality = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)((Enchantment)EnsorcEnchantments.VITALITY.get()));
        AttributeInstance healthAttr = entity.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            healthAttr.m_22120_(Constants.UUID_ENCH_VITALITY_HEALTH);
            if (encVitality > 0) {
                healthAttr.m_22118_(new AttributeModifier(Constants.UUID_ENCH_VITALITY_HEALTH, "vitality", (double)(encVitality * VitalityEnchantment.health), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.CURSE_FOOL.get()));
            if (encFool > 0) {
                event.setDroppedExperience(0);
                event.setCanceled(true);
                return;
            }
            int encExpBoost = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.XP_BOOST.get()));
            if (encExpBoost > 0) {
                event.setDroppedExperience(XpBoostEnchantment.getExp(event.getDroppedExperience(), encExpBoost, player.f_19853_.f_46441_));
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        int encInstigating;
        int encVorpal;
        int encMagicEdge;
        int encFrostAspect;
        int encCavalier;
        int encDamageVillager;
        int encDamageIllager;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)attacker;
        int encDamageEnder = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.DAMAGE_ENDER.get()));
        if (encDamageEnder > 0 && DamageEnderEnchantment.validTarget((Entity)entity)) {
            event.setAmount(event.getAmount() + DamageEnderEnchantment.getExtraDamage((int)encDamageEnder));
        }
        if ((encDamageIllager = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.DAMAGE_ILLAGER.get()))) > 0 && DamageIllagerEnchantment.validTarget((Entity)entity)) {
            event.setAmount(event.getAmount() + DamageIllagerEnchantment.getExtraDamage((int)encDamageIllager));
        }
        if ((encDamageVillager = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.DAMAGE_VILLAGER.get()))) > 0 && DamageVillagerEnchantment.validTarget((Entity)entity)) {
            event.setAmount(event.getAmount() + DamageVillagerEnchantment.getExtraDamage((int)encDamageVillager));
        }
        if ((encCavalier = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.CAVALIER.get()))) > 0 && living.m_20202_() != null) {
            event.setAmount(event.getAmount() * (1.0f + CavalierEnchantment.damageMult * (float)MathHelper.nextInt((int)1, (int)encCavalier)));
        }
        if ((encFrostAspect = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.FROST_ASPECT.get()))) > 0) {
            FrostAspectEnchantment.onHit(entity, encFrostAspect);
            if (FrostAspectEnchantment.validTarget((Entity)entity)) {
                event.setAmount(event.getAmount() + FrostAspectEnchantment.getExtraDamage(encFrostAspect));
            }
        }
        if ((encMagicEdge = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.MAGIC_EDGE.get()))) > 0 && source.m_19387_()) {
            event.setAmount(event.getAmount() + MagicEdgeEnchantment.getExtraDamage(encMagicEdge));
            MagicEdgeEnchantment.onHit(entity, encMagicEdge);
        }
        if ((encVorpal = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.VORPAL.get()))) > 0 && entity.f_19853_.f_46441_.nextInt(100) < VorpalEnchantment.critBase + VorpalEnchantment.critLevel * encVorpal) {
            event.setAmount(event.getAmount() * (float)VorpalEnchantment.critDamage);
            VorpalEnchantment.onHit(entity, encVorpal);
        }
        if ((encInstigating = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)((Enchantment)EnsorcEnchantments.INSTIGATING.get()))) > 0 && entity.m_21223_() >= entity.m_21233_()) {
            event.setAmount(event.getAmount() * (float)(1 + encInstigating));
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        int encFrostWalker = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)Enchantments.f_44974_);
        if (encFrostWalker > 0) {
            FrostWalkerEnchantment.m_45018_((LivingEntity)entity, (Level)entity.f_19853_, (BlockPos)entity.m_142538_(), (int)encFrostWalker);
            FrostWalkerEnchantmentImp.freezeNearby(entity, entity.f_19853_, entity.m_142538_(), encFrostWalker);
        }
    }

    @SubscribeEvent
    public static void handleItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        int encGourmand;
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof Player) || entity instanceof FakePlayer) {
            return;
        }
        FoodProperties food = event.getItem().m_41720_().m_41473_();
        if (food != null && (encGourmand = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)((Enchantment)EnsorcEnchantments.GOURMAND.get()))) > 0 && food != null) {
            int foodLevel = food.m_38744_();
            float foodSaturation = food.m_38745_();
            FoodData playerStats = ((Player)entity).m_36324_();
            int playerFood = playerStats.m_38702_();
            playerStats.m_38707_(foodLevel + encGourmand, foodSaturation + (float)encGourmand * 0.1f);
            playerStats.m_38705_(Math.min(playerFood + encGourmand, 20));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleItemFishedEvent(ItemFishedEvent event) {
        int encExpBoost;
        if (event.isCanceled()) {
            return;
        }
        FishingHook hook = event.getHookEntity();
        Entity angler = hook.m_37282_();
        if (!(angler instanceof Player)) {
            return;
        }
        Player player = (Player)angler;
        int encAngler = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.ANGLER.get()));
        if (encAngler > 0) {
            ItemStack fishingRod = player.m_21205_();
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)hook.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)hook.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)fishingRod).m_78977_(hook.f_19853_.f_46441_).m_78963_((float)hook.f_37096_ + player.m_36336_());
            contextBuilder.m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81455_, (Object)hook);
            LootTable table = hook.f_19853_.m_142572_().m_129898_().m_79217_(BuiltInLootTables.f_78720_);
            ArrayList list = new ArrayList();
            for (int i = 0; i < encAngler; ++i) {
                if (player.m_21187_().nextInt(100) >= AnglerEnchantment.chance) continue;
                list.addAll(table.m_79129_(contextBuilder.m_78975_(LootContextParamSets.f_81414_)));
            }
            for (ItemStack stack : list) {
                ItemEntity drop = new ItemEntity(hook.f_19853_, hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), stack);
                double d0 = player.m_20185_() - hook.m_20185_();
                double d1 = player.m_20186_() - hook.m_20186_();
                double d2 = player.m_20189_() - hook.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                drop.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(d3) * 0.08, d2 * 0.1);
                hook.f_19853_.m_7967_((Entity)drop);
                if (!stack.m_204117_(ItemTags.f_13156_)) continue;
                player.m_36222_(Stats.f_12939_, 1);
            }
        }
        if ((encExpBoost = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.XP_BOOST.get()))) > 0) {
            hook.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, XpBoostEnchantment.getExp(0, encExpBoost, player.f_19853_.f_46441_)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        Player player = event.getPlayer();
        ExperienceOrb orb = event.getOrb();
        int encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.CURSE_FOOL.get()));
        if (encFool > 0) {
            orb.f_20770_ = 0;
            orb.m_146870_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handlePlayerRightClickEvent(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.f_36083_ == null || Utils.isClientWorld((Level)player.f_19853_)) {
            return;
        }
        FishingHook hook = player.f_36083_;
        Entity entity = hook.m_37170_();
        if (entity instanceof Player && !PilferingEnchantment.allowPlayerStealing) {
            return;
        }
        int encPilfer = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.PILFERING.get()));
        if (encPilfer > 0 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack armor = CommonEvents.stealArmor(living);
            if (armor.m_41619_()) {
                return;
            }
            ItemEntity armorEntity = new ItemEntity(living.f_19853_, living.m_20185_(), living.m_20186_() + 0.5, living.m_20189_(), armor);
            armorEntity.m_32047_(player.m_142081_());
            armorEntity.m_32010_(5);
            armorEntity.f_19853_.m_7967_((Entity)armorEntity);
            armorEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    @SubscribeEvent
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (event.getExpToDrop() > 0) {
            int encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.CURSE_FOOL.get()));
            if (encFool > 0) {
                event.setExpToDrop(0);
                return;
            }
            int encExpBoost = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.XP_BOOST.get()));
            if (encExpBoost > 0) {
                event.setExpToDrop(XpBoostEnchantment.getExp(event.getExpToDrop(), encExpBoost, player.f_19853_.f_46441_));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        int encAirAffinity = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.AIR_AFFINITY.get()));
        if (encAirAffinity > 0 && !player.m_20096_()) {
            event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
        }
    }

    @SubscribeEvent
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FireRebukeEnchantment.setFireToMobs();
        }
    }

    private static ItemStack stealArmor(LivingEntity living) {
        ItemStack stack = ItemStack.f_41583_;
        for (EquipmentSlot slot : Constants.ARMOR_SLOTS) {
            if (living.m_6844_(slot).m_41619_()) continue;
            stack = living.m_6844_(slot);
            living.m_8061_(slot, ItemStack.f_41583_);
            break;
        }
        return stack;
    }
}

