/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.method;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.network.PacketAddFadingLight;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class MethodTouch
extends AbstractCastMethod {
    public static MethodTouch INSTANCE = new MethodTouch();

    private MethodTouch() {
        super("touch", "Touch");
    }

    @Override
    public int getDefaultManaCost() {
        return 5;
    }

    @Override
    public void onCast(ItemStack stack, LivingEntity caster, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
    }

    @Override
    public void onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.m_43725_();
        BlockHitResult res = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        resolver.onResolveEffect(world, (HitResult)res);
        resolver.expendMana((LivingEntity)context.m_43723_());
        Networking.sendToNearby(context.m_43725_(), (Entity)context.m_43723_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, res.m_82425_(), spellContext.colors, new int[0]));
        this.addFadingLight(context.m_43725_(), (double)res.m_82425_().m_123341_() + 0.5, (double)res.m_82425_().m_123342_() + 0.5, (double)res.m_82425_().m_123343_() + 0.5);
    }

    @Override
    public void onCastOnBlock(BlockHitResult res, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        resolver.onResolveEffect(caster.m_20193_(), caster, (HitResult)res);
        resolver.expendMana(caster);
        Networking.sendToNearby(caster.f_19853_, (Entity)caster, (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, res.m_82425_(), spellContext.colors, new int[0]));
        this.addFadingLight(caster.m_183503_(), (double)res.m_82425_().m_123341_() + 0.5, (double)res.m_82425_().m_123342_() + 0.5, (double)res.m_82425_().m_123343_() + 0.5);
    }

    @Override
    public void onCastOnEntity(ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        resolver.onResolveEffect(caster.m_20193_(), caster, (HitResult)new EntityHitResult(target));
        if (spellContext.getType() != SpellContext.CasterType.RUNE) {
            resolver.expendMana(caster);
        }
        Networking.sendToNearby(caster.f_19853_, (Entity)caster, (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, target.m_142538_(), spellContext.colors, new int[0]));
        this.addFadingLight(caster.m_183503_(), (double)target.m_142538_().m_123341_() + 0.5, (double)target.m_142538_().m_123342_() + 0.5, (double)target.m_142538_().m_123343_() + 0.5);
    }

    public void addFadingLight(Level level, double x, double y, double z) {
        Networking.sendToNearby(level, new BlockPos(x, y, z), (Object)new PacketAddFadingLight(x, y, z, (Integer)Config.TOUCH_LIGHT_DURATION.get(), (Integer)Config.TOUCH_LIGHT_LUMINANCE.get()));
    }

    @Override
    public boolean wouldCastSuccessfully(@Nullable ItemStack stack, LivingEntity playerEntity, Level world, SpellStats spellStats, SpellResolver resolver) {
        return false;
    }

    @Override
    public boolean wouldCastOnBlockSuccessfully(UseOnContext context, SpellStats spellStats, SpellResolver resolver) {
        Level world = context.m_43725_();
        BlockHitResult res = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        return resolver.wouldAllEffectsDoWork((HitResult)res, world, (LivingEntity)context.m_43723_(), spellStats);
    }

    @Override
    public boolean wouldCastOnBlockSuccessfully(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellResolver resolver) {
        return resolver.wouldAllEffectsDoWork((HitResult)blockRayTraceResult, caster.m_20193_(), caster, spellStats);
    }

    @Override
    public boolean wouldCastOnEntitySuccessfully(@Nullable ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellResolver resolver) {
        return resolver.wouldAllEffectsDoWork((HitResult)new EntityHitResult(target), caster.m_20193_(), caster, spellStats);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Applies spells at the block or entity that is targeted.";
    }

    @Override
    public boolean defaultedStarterGlyph() {
        return true;
    }
}

