/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class RitualAwakening
extends AbstractRitual {
    List<BlockPos> treePos = new ArrayList<BlockPos>();
    EntityType<? extends LivingEntity> entity = null;
    BlockPos foundPos;

    public void destroyTree(Level world, Set<BlockPos> set) {
        for (BlockPos p : set) {
            BlockUtil.destroyBlockSafelyWithoutSound(world, p, false);
        }
    }

    public void findTargets(Level world) {
        for (BlockPos p : BlockPos.m_121925_((BlockPos)this.getPos(), (int)3, (int)1, (int)3)) {
            Set<BlockPos> blazing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.m_60734_() == BlockRegistry.BLAZING_LOG || b.m_60734_() == BlockRegistry.BLAZING_LEAVES);
            if (blazing.size() >= 50) {
                this.entity = ModEntities.ENTITY_BLAZING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, blazing);
                return;
            }
            Set<BlockPos> flourishing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.m_60734_() == BlockRegistry.FLOURISHING_LOG || b.m_60734_() == BlockRegistry.FLOURISHING_LEAVES);
            if (flourishing.size() >= 50) {
                this.entity = ModEntities.ENTITY_FLOURISHING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, flourishing);
                return;
            }
            Set<BlockPos> vexing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.m_60734_() == BlockRegistry.VEXING_LOG || b.m_60734_() == BlockRegistry.VEXING_LEAVES);
            if (vexing.size() >= 50) {
                this.entity = ModEntities.ENTITY_VEXING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, vexing);
                return;
            }
            Set<BlockPos> cascading = SpellUtil.DFSBlockstates(world, p, 350, b -> b.m_60734_() == BlockRegistry.CASCADING_LOG || b.m_60734_() == BlockRegistry.CASCADING_LEAVE);
            if (cascading.size() >= 50) {
                this.entity = ModEntities.ENTITY_CASCADING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, cascading);
                return;
            }
            if (world.m_8055_(p).m_60734_() != Blocks.f_152491_) continue;
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            this.entity = ModEntities.AMETHYST_GOLEM;
            this.foundPos = p;
            return;
        }
    }

    @Override
    protected void tick() {
        Level world = this.getWorld();
        if (world.f_46443_) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 100; ++i) {
                Vec3 particlePos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 0.0, 0.5);
                particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere().m_82542_(5.0, 5.0, 5.0));
                world.m_7106_(ParticleLineData.createData(this.getCenterColor()), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
            }
        }
        if (!world.f_46443_ && world.m_46467_() % 20L == 0L) {
            this.incrementProgress();
            if (this.getProgress() > 5) {
                this.findTargets(world);
                if (this.entity != null) {
                    ParticleUtil.spawnPoof((ServerLevel)world, this.foundPos);
                    LivingEntity walker = (LivingEntity)this.entity.m_20615_(world);
                    walker.m_6034_((double)this.foundPos.m_123341_() + 0.5, (double)this.foundPos.m_123342_(), (double)this.foundPos.m_123343_() + 0.5);
                    world.m_7967_((Entity)walker);
                    this.setFinished();
                }
            }
        }
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(50, 200, 50);
    }

    @Override
    public void write(CompoundTag tag) {
        super.write(tag);
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
    }

    @Override
    public String getLangName() {
        return "Awakening";
    }

    @Override
    public String getLangDescription() {
        return "Awakens nearby Archwood trees into Weald Walkers and Budding Amethyst into Amethyst Golems. Weald Walkers can be given a position in the world to guard against hostile mobs. They will heal over time, and turn into Weald Waddlers if they die. To create a Weald Walker, perform this ritual near the base of an Archwood Tree.";
    }

    @Override
    public String getID() {
        return "awakening";
    }
}

