/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.BasicReductionCaster;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.renderer.item.SwordRenderer;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EnchantersSword
extends SwordItem
implements ICasterTool,
IAnimatable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EnchantersSword(Tier iItemTier, int baseDamage, float baseAttackSpeed) {
        super(iItemTier, baseDamage, baseAttackSpeed, ItemsRegistry.defaultItemProperties().m_41487_(1));
    }

    public EnchantersSword(Tier iItemTier, int baseDamage, float baseAttackSpeed, Item.Properties properties) {
        super(iItemTier, baseDamage, baseAttackSpeed, properties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        super.m_6883_(stack, world, entity, p_77663_4_, p_77663_5_);
        if (world.m_5776_() || world.m_46467_() % 200L != 0L || stack.m_41773_() == 0 || !(entity instanceof Player)) {
            return;
        }
        CapabilityRegistry.getMana((LivingEntity)entity).ifPresent(mana -> {
            if (mana.getCurrentMana() > 20.0) {
                mana.removeMana(20.0);
                stack.m_41721_(stack.m_41773_() - 1);
            }
        });
    }

    @Override
    public boolean isScribedSpellValid(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)new TranslatableComponent("ars_nouveau.sword.invalid"));
    }

    @Override
    public boolean setSpell(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodTouch.INSTANCE);
        recipe.addAll(spell.recipe);
        recipe.add(AugmentAmplify.INSTANCE);
        spell.recipe = recipe;
        return ICasterTool.super.setSpell(caster, player, hand, stack, spell);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity player) {
        ISpellCaster caster = this.getSpellCaster(stack);
        SpellResolver resolver = new SpellResolver(new SpellContext(caster.getSpell(), player).withColors(caster.getColor()));
        EntityHitResult entityRes = new EntityHitResult((Entity)target);
        resolver.onCastOnEntity(stack, player, entityRes.m_82443_(), InteractionHand.MAIN_HAND);
        return super.m_7579_(stack, target, player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new SwordRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new BasicReductionCaster(stack, spell -> {
            spell.setCost(spell.getCastingCost() - AugmentAmplify.INSTANCE.getDefaultManaCost());
            return spell;
        });
    }
}

