/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TakeItemGoal
extends ExtendedRangeGoal {
    Starbuncle starbuncle;
    BlockPos takePos;
    boolean unreachable;

    public TakeItemGoal(Starbuncle starbuncle) {
        super(25);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.starbuncle = starbuncle;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.takePos = null;
        this.unreachable = false;
        this.startDistance = 0.0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.takePos = this.starbuncle.getValidTakePos();
        this.unreachable = false;
        if (this.starbuncle.isTamed() && this.takePos != null && this.starbuncle.getHeldStack().m_41619_()) {
            this.startDistance = BlockUtil.distanceFrom(this.starbuncle.f_19825_, this.takePos);
            this.setPath(this.takePos.m_123341_(), this.takePos.m_123342_(), this.takePos.m_123343_(), 1.2);
        }
        if (this.takePos == null) {
            this.starbuncle.setBackOff(60 + this.starbuncle.f_19853_.f_46441_.nextInt(60));
        }
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    public void getItem() {
        Level world = this.starbuncle.f_19853_;
        if (world.m_7702_(this.takePos) == null) {
            return;
        }
        IItemHandler iItemHandler = (IItemHandler)world.m_7702_(this.takePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (iItemHandler == null) {
            return;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            int count;
            if (iItemHandler.getStackInSlot(j).m_41619_() || (count = this.starbuncle.getMaxTake(iItemHandler.getStackInSlot(j))) <= 0) continue;
            this.starbuncle.getValidStorePos(iItemHandler.getStackInSlot(j));
            this.starbuncle.setHeldStack(iItemHandler.extractItem(j, count, false));
            this.starbuncle.f_19853_.m_6263_(null, this.starbuncle.m_20185_(), this.starbuncle.m_20186_(), this.starbuncle.m_20189_(), SoundEvents.f_12019_, this.starbuncle.m_5720_(), 1.0f, 1.0f);
            if (!(world instanceof ServerLevel)) break;
            ServerLevel serverLevel = (ServerLevel)world;
            try {
                OpenChestEvent event = new OpenChestEvent(serverLevel, this.takePos, 20);
                event.open();
                EventQueue.getServerInstance().addEvent(event);
            }
            catch (Throwable throwable) {}
            break;
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(new BlockPos(x, y, z), 1.3);
        if (this.starbuncle.getNavigation().m_26570_() != null && !this.starbuncle.getNavigation().m_26570_().m_77403_()) {
            this.unreachable = true;
        }
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.ticksRunning % 100 == 0 && !this.starbuncle.isPositionValidTake(this.takePos)) {
            this.takePos = null;
            return;
        }
        if (this.starbuncle.getHeldStack().m_41619_() && this.takePos != null && BlockUtil.distanceFrom(this.starbuncle.m_20182_(), this.takePos) <= 2.0 + this.extendedRange) {
            Level world = this.starbuncle.f_19853_;
            BlockEntity tileEntity = world.m_7702_(this.takePos);
            if (tileEntity == null) {
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                this.getItem();
                return;
            }
        }
        if (this.takePos != null && this.starbuncle.getHeldStack().m_41619_()) {
            this.setPath(this.takePos.m_123341_(), this.takePos.m_123342_(), this.takePos.m_123343_(), 1.3);
        }
    }

    public boolean m_8045_() {
        return !this.unreachable && !this.starbuncle.isStuck && this.starbuncle.getHeldStack() != null && this.starbuncle.getHeldStack().m_41619_() && this.starbuncle.getBackOff() == 0 && this.starbuncle.isTamed() && this.takePos != null;
    }

    @Override
    public boolean m_8036_() {
        return !this.starbuncle.isStuck && this.starbuncle.getHeldStack() != null && this.starbuncle.getHeldStack().m_41619_() && this.starbuncle.getBackOff() == 0 && this.starbuncle.isTamed();
    }

    public boolean m_6767_() {
        return super.m_6767_();
    }
}

