/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.goal.guardian.LaserAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenMeleeAttack;
import com.hollingsworth.arsnouveau.setup.Config;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildenGuardian
extends Monster
implements IAnimatable,
IAnimationListener {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public int laserCooldown;
    public int armorCooldown;
    public int armorTimeRemaining;
    public Vec3 orbitOffset = Vec3.f_82478_;
    public BlockPos orbitPosition = BlockPos.f_121853_;
    private LivingEntity targetedEntity;
    public static final EntityDataAccessor<Boolean> isLaser = SynchedEntityData.m_135353_(WildenGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_ARMORED = SynchedEntityData.m_135353_(WildenGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TARGET_ENTITY = SynchedEntityData.m_135353_(WildenGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CLIENT_TIME = SynchedEntityData.m_135353_(WildenGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimationController attackController;

    public WildenGuardian(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public WildenGuardian(Level worldIn) {
        this(ModEntities.WILDEN_GUARDIAN, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new WildenMeleeAttack((PathfinderMob)this, 0.8, true, Animations.ATTACK.ordinal(), () -> (Boolean)this.f_19804_.m_135370_(isLaser) == false));
        this.f_21345_.m_25352_(4, (Goal)new LaserAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.GUARDIAN_ATTACK_ANIMALS.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TARGET_ENTITY.equals(key)) {
            this.setClientAttackTime(0);
            this.targetedEntity = null;
        }
    }

    public void setClientAttackTime(int i) {
        this.f_19804_.m_135381_(CLIENT_TIME, (Object)i);
    }

    public int getClientAttackTime() {
        return (Integer)this.f_19804_.m_135370_(CLIENT_TIME);
    }

    public boolean getIsLaser() {
        return (Boolean)this.f_19804_.m_135370_(isLaser);
    }

    public void setLaser(boolean isLasering) {
        this.f_19804_.m_135381_(isLaser, (Object)isLasering);
    }

    public boolean isArmored() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMORED);
    }

    public void setArmored(boolean isArmored) {
        this.f_19804_.m_135381_(IS_ARMORED, (Object)isArmored);
    }

    public void setTargetedEntity(int entityId) {
        this.f_19804_.m_135381_(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ENTITY) != 0;
    }

    public boolean m_7327_(Entity entityIn) {
        return super.m_7327_(entityIn);
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.m_5448_();
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (!this.f_19853_.f_46443_ && this.armorCooldown == 0) {
            this.setArmored(true);
            this.armorCooldown = 200;
            this.armorTimeRemaining = 100;
        }
        if (!this.f_19853_.f_46443_ && this.isArmored() && !damageSrc.m_19376_()) {
            damageAmount = (float)((double)damageAmount * 0.75);
            if (damageSrc.m_7639_() != null && BlockUtil.distanceFrom(damageSrc.m_7639_().f_19825_, this.f_19825_) <= 2.0 && !damageSrc.f_19326_.equals("thorns")) {
                damageSrc.m_7639_().m_6469_(DamageSource.m_19335_((Entity)this), 3.0f);
            }
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.laserCooldown > 0) {
                --this.laserCooldown;
            }
            if (this.armorTimeRemaining > 0) {
                --this.armorTimeRemaining;
            }
            if (this.armorTimeRemaining == 0 && this.isArmored()) {
                this.setArmored(false);
            }
            if (this.armorCooldown > 0) {
                --this.armorCooldown;
            }
        }
        if (this.hasTargetedEntity() && this.getIsLaser()) {
            LivingEntity livingentity;
            if (this.getClientAttackTime() < this.getAttackDuration()) {
                this.setClientAttackTime(this.getClientAttackTime() + 1);
            }
            if ((livingentity = this.getTargetedEntity()) != null) {
                this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                this.m_21563_().m_8128_();
            }
        }
    }

    @Override
    public void startAnimation(int arg) {
        try {
            AnimationController controller = this.attackController;
            if (this.attackController == null) {
                return;
            }
            if (arg == WildenHunter.Animations.ATTACK.ordinal()) {
                if (controller.getCurrentAnimation() != null && (controller.getCurrentAnimation().animationName.equals("attack") || controller.getCurrentAnimation().animationName.equals("attack2") || controller.getCurrentAnimation().animationName.equals("howl"))) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("attack").addAnimation("idle"));
            }
            if (arg == WildenHunter.Animations.RAM.ordinal()) {
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("attack2")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("attack2").addAnimation("idle"));
            }
            if (arg == WildenHunter.Animations.HOWL.ordinal()) {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("howl").addAnimation("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(isLaser, (Object)false);
        this.f_19804_.m_135372_(TARGET_ENTITY, (Object)0);
        this.f_19804_.m_135372_(CLIENT_TIME, (Object)0);
        this.f_19804_.m_135372_(IS_ARMORED, (Object)false);
    }

    private <E extends Entity> PlayState attackPredicate(AnimationEvent event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        this.attackController = new AnimationController((IAnimatable)this, "attackController", 1.0f, this::attackPredicate);
        animationData.addAnimationController(this.attackController);
    }

    public int getAttackDuration() {
        return 80;
    }

    public float getAttackAnimationScale(float p_175477_1_) {
        return ((float)this.getClientAttackTime() + p_175477_1_) / (float)this.getAttackDuration();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.armorCooldown = compound.m_128451_("armorCooldown");
        this.armorTimeRemaining = compound.m_128451_("armorTimeRemaining");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("armorCooldown", this.armorCooldown);
        compound.m_128405_("armorTimeRemaining", this.armorTimeRemaining);
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 4.5).m_22268_(Attributes.f_22284_, 2.0);
    }

    static enum Animations {
        ATTACK;

    }
}

